/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.grouplens;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.regex.Pattern;
import org.apache.mahout.cf.taste.example.grouplens.GroupLensRecommender;
import org.apache.mahout.cf.taste.impl.model.file.FileDataModel;
import org.apache.mahout.common.IOUtils;
import org.apache.mahout.common.iterator.FileLineIterable;

public final class GroupLensDataModel
extends FileDataModel {
    private static final String COLON_DELIMTER = "::";
    private static final Pattern COLON_DELIMITER_PATTERN = Pattern.compile("::");

    public GroupLensDataModel() throws IOException {
        this(GroupLensDataModel.readResourceToTempFile("/org/apache/mahout/cf/taste/example/grouplens/ratings.dat"));
    }

    public GroupLensDataModel(File ratingsFile) throws IOException {
        super(GroupLensDataModel.convertGLFile(ratingsFile));
    }

    private static File convertGLFile(File originalFile) throws IOException {
        File resultFile = new File(new File(System.getProperty("java.io.tmpdir")), "ratings.txt");
        if (resultFile.exists()) {
            resultFile.delete();
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(resultFile), Charsets.UTF_8));
            for (String line : new FileLineIterable(originalFile, false)) {
                int lastDelimiterStart = line.lastIndexOf(COLON_DELIMTER);
                if (lastDelimiterStart < 0) {
                    throw new IOException("Unexpected input format on line: " + line);
                }
                String subLine = line.substring(0, lastDelimiterStart);
                String convertedLine = COLON_DELIMITER_PATTERN.matcher(subLine).replaceAll(",");
                writer.println(convertedLine);
            }
            writer.flush();
        }
        catch (IOException ioe) {
            try {
                resultFile.delete();
                throw ioe;
            }
            catch (Throwable throwable) {
                IOUtils.quietClose((Closeable[])new Closeable[]{writer});
                throw throwable;
            }
        }
        IOUtils.quietClose((Closeable[])new Closeable[]{writer});
        return resultFile;
    }

    public static File readResourceToTempFile(String resourceName) throws IOException {
        InputSupplier inSupplier;
        try {
            URL resourceURL = Resources.getResource(GroupLensRecommender.class, (String)resourceName);
            inSupplier = Resources.newInputStreamSupplier((URL)resourceURL);
        }
        catch (IllegalArgumentException iae) {
            File resourceFile = new File("src/main/java" + resourceName);
            inSupplier = Files.newInputStreamSupplier((File)resourceFile);
        }
        File tempFile = File.createTempFile("taste", null);
        tempFile.deleteOnExit();
        Files.copy((InputSupplier)inSupplier, (File)tempFile);
        return tempFile;
    }

    public String toString() {
        return "GroupLensDataModel";
    }
}

