/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.bookcrossing;

import com.google.common.base.Charsets;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.regex.Pattern;
import org.apache.mahout.cf.taste.example.grouplens.GroupLensDataModel;
import org.apache.mahout.cf.taste.impl.model.file.FileDataModel;
import org.apache.mahout.common.IOUtils;
import org.apache.mahout.common.iterator.FileLineIterable;

public final class BookCrossingDataModel
extends FileDataModel {
    private static final Pattern NON_DIGIT_SEMICOLON_PATTERN = Pattern.compile("[^0-9;]");

    public BookCrossingDataModel(boolean ignoreRatings) throws IOException {
        this(GroupLensDataModel.readResourceToTempFile("/org/apache/mahout/cf/taste/example/bookcrossing/BX-Book-Ratings.csv"), ignoreRatings);
    }

    public BookCrossingDataModel(File ratingsFile, boolean ignoreRatings) throws IOException {
        super(BookCrossingDataModel.convertBCFile(ratingsFile, ignoreRatings));
    }

    private static File convertBCFile(File originalFile, boolean ignoreRatings) throws IOException {
        if (!originalFile.exists()) {
            throw new FileNotFoundException(originalFile.toString());
        }
        File resultFile = new File(new File(System.getProperty("java.io.tmpdir")), "taste.bookcrossing.txt");
        resultFile.delete();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(resultFile), Charsets.UTF_8));
            for (String line : new FileLineIterable(originalFile, true)) {
                String convertedLine;
                if (line.endsWith("\"0\"") || (convertedLine = NON_DIGIT_SEMICOLON_PATTERN.matcher(line).replaceAll("").replace(';', ',')).contains(",,")) continue;
                if (ignoreRatings) {
                    convertedLine = convertedLine.substring(0, convertedLine.lastIndexOf(44));
                }
                writer.println(convertedLine);
            }
            writer.flush();
        }
        catch (IOException ioe) {
            try {
                resultFile.delete();
                throw ioe;
            }
            catch (Throwable throwable) {
                IOUtils.quietClose((Closeable[])new Closeable[]{writer});
                throw throwable;
            }
        }
        IOUtils.quietClose((Closeable[])new Closeable[]{writer});
        return resultFile;
    }

    public String toString() {
        return "BookCrossingDataModel";
    }
}

