/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.analysis;

import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.wikipedia.WikipediaTokenizer;
import org.apache.lucene.util.Version;

public class WikipediaAnalyzer
extends Analyzer {
    private final CharArraySet stopSet;

    public WikipediaAnalyzer() {
        this.stopSet = (CharArraySet)StopFilter.makeStopSet((Version)Version.LUCENE_31, (String[])StopAnalyzer.ENGLISH_STOP_WORDS_SET.toArray(new String[StopAnalyzer.ENGLISH_STOP_WORDS_SET.size()]));
    }

    public WikipediaAnalyzer(CharArraySet stopSet) {
        this.stopSet = stopSet;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        WikipediaTokenizer result = new WikipediaTokenizer(reader);
        result = new StandardFilter(Version.LUCENE_31, (TokenStream)result);
        result = new LowerCaseFilter(Version.LUCENE_31, (TokenStream)result);
        result = new StopFilter(Version.LUCENE_31, (TokenStream)result, (Set)this.stopSet);
        return result;
    }
}

