/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.analysis.wordcount;

import java.io.IOException;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class WordCountReducer
extends TableReducer<Text, IntWritable, Text> {
    private String dateWordSeparator = "_";
    private String family = "d";
    private Text text = new Text();

    public void reduce(Text keyin, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        int wordCount = 0;
        for (IntWritable val : values) {
            wordCount += val.get();
        }
        String[] elements = keyin.toString().split(this.dateWordSeparator, 2);
        String date = elements[0];
        String word = elements[1];
        Put put = new Put(Bytes.toBytes((String)date));
        put.add(Bytes.toBytes((String)this.family), Bytes.toBytes((String)word), Bytes.toBytes((String)String.valueOf(wordCount)));
        this.text.set(date);
        context.write((Object)this.text, (Object)put);
    }
}

