/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.analysis.twitter;

import eu.dicodeproject.analysis.hbase.TweetCols;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.NavigableMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;

public class SchemaUpdaterMapper
extends TableMapper<NullWritable, NullWritable> {
    private static final byte[] OLD_CREATION_DATE = Bytes.toBytes((String)"creationDate");
    private static final byte[] OLD_FROM = Bytes.toBytes((String)"from");
    private static final byte[] OLD_FROM_ID = Bytes.toBytes((String)"fromId");
    private static final byte[] OLD_GEO = Bytes.toBytes((String)"geo");
    private static final byte[] OLD_IMAGE_URL = Bytes.toBytes((String)"imageUrl");
    private static final byte[] OLD_LANG = Bytes.toBytes((String)"lang");
    private static final byte[] OLD_SOURCE = Bytes.toBytes((String)"source");
    private static final byte[] OLD_TEXT = Bytes.toBytes((String)"text");
    private static final byte[] OLD_TO = Bytes.toBytes((String)"to");
    private byte[] sourceTextFamily;
    private byte[] sourceMetaFamily;
    private byte[] table;
    private byte[] family;
    private final DateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss +SSS");
    private HTablePool hTablePool;

    public void map(ImmutableBytesWritable key, Result tweet, Mapper.Context context) throws IOException, InterruptedException {
        Put put = new Put(key.get());
        NavigableMap tweetMap = tweet.getNoVersionMap();
        NavigableMap textMap = (NavigableMap)tweetMap.get(this.sourceTextFamily);
        this.addToPut(put, TweetCols.TEXT.bytes(), (byte[])textMap.get(OLD_TEXT));
        this.addToPut(put, TweetCols.FROM_ID.bytes(), (byte[])textMap.get(OLD_FROM_ID));
        NavigableMap metaMap = (NavigableMap)tweetMap.get(this.sourceMetaFamily);
        this.addToPut(put, TweetCols.FROM.bytes(), (byte[])metaMap.get(OLD_FROM));
        this.addToPut(put, TweetCols.SOURCE.bytes(), (byte[])metaMap.get(OLD_SOURCE));
        this.addToPut(put, TweetCols.TO.bytes(), (byte[])metaMap.get(OLD_TO));
        this.addToPut(put, TweetCols.GEO.bytes(), (byte[])metaMap.get(OLD_GEO));
        this.addToPut(put, TweetCols.IMAGE_URL.bytes(), (byte[])metaMap.get(OLD_IMAGE_URL));
        this.addToPut(put, TweetCols.LANG.bytes(), (byte[])metaMap.get(OLD_LANG));
        try {
            String creationDate = Bytes.toString((byte[])((byte[])metaMap.get(OLD_CREATION_DATE)));
            byte[] creationDateUnix = Bytes.toBytes((long)this.dateFormat.parse(creationDate).getTime());
            this.addToPut(put, TweetCols.CREATION_DATE.bytes(), creationDateUnix);
        }
        catch (ParseException e) {
            context.getCounter("SchemaUpdaterMapper", "ParseException").increment(1L);
        }
        HTableInterface table = this.hTablePool.getTable(this.table);
        table.put(put);
        this.hTablePool.putTable(table);
    }

    private void addToPut(Put put, byte[] col, byte[] value) {
        if (value != null && value.length > 0) {
            put.add(this.family, col, value);
        }
    }

    public void setup(Mapper.Context context) throws IOException, InterruptedException {
        Configuration cfg = context.getConfiguration();
        this.sourceTextFamily = cfg.get("sourceTextFamily").getBytes();
        this.sourceMetaFamily = cfg.get("sourceMetaFamily").getBytes();
        this.table = cfg.get("table").getBytes();
        this.family = cfg.get("family").getBytes();
        this.hTablePool = new HTablePool(cfg, 10);
        super.setup(context);
    }
}

