/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.analysis.lucene;

import eu.dicodeproject.analysis.lucene.StemmerFactory;
import eu.dicodeproject.analysis.util.Language;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.en.EnglishPossessiveFilter;
import org.apache.lucene.analysis.fr.ElisionFilter;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.UAX29URLEmailTokenizer;
import org.apache.lucene.analysis.tr.TurkishLowerCaseFilter;
import org.apache.lucene.util.Version;

public class TweetAnalyzer
extends StopwordAnalyzerBase {
    private Language language;

    public TweetAnalyzer(Language language, Version matchVersion, Set<?> stopwords) {
        super(matchVersion, stopwords);
        this.language = language;
    }

    public TweetAnalyzer(Language language, Version matchVersion) {
        this(language, matchVersion, StandardAnalyzer.STOP_WORDS_SET);
    }

    public TweetAnalyzer(String langCode, Version matchVersion, Set<?> stopwords) {
        this(Language.fromCode(langCode), matchVersion, stopwords);
    }

    public TweetAnalyzer(String langCode, Version matchVersion) {
        this(Language.fromCode(langCode), matchVersion, StandardAnalyzer.STOP_WORDS_SET);
    }

    public ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        UAX29URLEmailTokenizer source = new UAX29URLEmailTokenizer(reader);
        Object result = new StandardFilter(this.matchVersion, (TokenStream)source);
        if (this.matchVersion.onOrAfter(Version.LUCENE_31)) {
            if (this.language == Language.ENGLISH) {
                result = new EnglishPossessiveFilter((TokenStream)result);
            } else if (this.language == Language.FRENCH) {
                result = new ElisionFilter(this.matchVersion, (TokenStream)result);
            }
        }
        result = this.language == Language.TURKISH ? new TurkishLowerCaseFilter((TokenStream)result) : new LowerCaseFilter(this.matchVersion, (TokenStream)result);
        result = new StopFilter(this.matchVersion, (TokenStream)result, (Set)this.stopwords);
        result = StemmerFactory.getStemmer(this.language, this.matchVersion, (TokenStream)result);
        return new ReusableAnalyzerBase.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
    }
}

