/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.analysis.lucene;

import eu.dicodeproject.analysis.util.Language;
import org.apache.lucene.analysis.PorterStemFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.de.GermanStemFilter;
import org.apache.lucene.analysis.id.IndonesianStemFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.util.Version;
import org.tartarus.snowball.SnowballProgram;
import org.tartarus.snowball.ext.DutchStemmer;
import org.tartarus.snowball.ext.FrenchStemmer;
import org.tartarus.snowball.ext.German2Stemmer;
import org.tartarus.snowball.ext.ItalianStemmer;
import org.tartarus.snowball.ext.PortugueseStemmer;
import org.tartarus.snowball.ext.RussianStemmer;
import org.tartarus.snowball.ext.SpanishStemmer;
import org.tartarus.snowball.ext.TurkishStemmer;

public class StemmerFactory {
    public static TokenFilter getStemmer(Language language, Version matchVersion, TokenStream result) {
        if (language == Language.ENGLISH) {
            return new PorterStemFilter(result);
        }
        if (language == Language.SPANISH) {
            return new SnowballFilter(result, (SnowballProgram)new SpanishStemmer());
        }
        if (language == Language.PORTUGUESE) {
            return new SnowballFilter(result, (SnowballProgram)new PortugueseStemmer());
        }
        if (language == Language.FRENCH) {
            return new SnowballFilter(result, (SnowballProgram)new FrenchStemmer());
        }
        if (language == Language.DUTCH) {
            return new SnowballFilter(result, (SnowballProgram)new DutchStemmer());
        }
        if (language == Language.GERMAN) {
            if (matchVersion.onOrAfter(Version.LUCENE_31)) {
                return new SnowballFilter(result, (SnowballProgram)new German2Stemmer());
            }
            return new GermanStemFilter(result);
        }
        if (language == Language.INDONESIAN) {
            return new IndonesianStemFilter(result);
        }
        if (language == Language.ITALIAN) {
            return new SnowballFilter(result, (SnowballProgram)new ItalianStemmer());
        }
        if (language == Language.RUSSIAN) {
            return new SnowballFilter(result, (SnowballProgram)new RussianStemmer());
        }
        if (language == Language.TURKISH) {
            return new SnowballFilter(result, (SnowballProgram)new TurkishStemmer());
        }
        return new StandardFilter(matchVersion, result);
    }
}

