/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.analysis.histogram;

import java.io.IOException;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class DateHistogramReducer
extends TableReducer<Text, IntWritable, Text> {
    private String splitExpression = "_";
    private Text text = new Text();
    private String family = "d";

    protected void reduce(Text keyin, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        String[] elements = keyin.toString().split(this.splitExpression);
        String dateType = elements[0];
        String dateValue = elements[1];
        int sum = 0;
        for (IntWritable i : values) {
            sum += i.get();
        }
        this.writeRow(context, dateValue, dateType, String.valueOf(sum));
    }

    private void writeRow(Reducer.Context context, String rowKey, String qualifier, String value) throws IOException, InterruptedException {
        Put put = new Put(Bytes.toBytes((String)rowKey));
        put.add(Bytes.toBytes((String)this.family), Bytes.toBytes((String)qualifier), Bytes.toBytes((String)value));
        this.text.set(rowKey);
        context.write((Object)this.text, (Object)put);
    }
}

