/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.analysis.histogram;

import java.io.IOException;
import java.util.Calendar;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class DateHistogramMapper
extends TableMapper<Text, IntWritable> {
    private String splitExpression = "_";
    private Text resultKey = new Text();
    private IntWritable one = new IntWritable(1);
    private Calendar cal = Calendar.getInstance();

    protected void map(ImmutableBytesWritable row, Result values, Mapper.Context context) throws IOException, InterruptedException {
        byte[] creationDateBytes = values.value();
        if (creationDateBytes == null) {
            context.getCounter((Enum)ErrorCases.DATENULL).increment(1L);
            return;
        }
        this.cal.setTimeInMillis(Bytes.toLong((byte[])creationDateBytes));
        String year = String.valueOf(this.cal.get(1));
        this.resultKey.set("year" + this.splitExpression + year);
        context.write((Object)this.resultKey, (Object)this.one);
        String month = String.valueOf(this.cal.get(2) + 1);
        if (month.length() == 1) {
            month = "0" + month;
        }
        this.resultKey.set("yearMonth" + this.splitExpression + year + "-" + month);
        context.write((Object)this.resultKey, (Object)this.one);
        String day = String.valueOf(this.cal.get(5));
        if (day.length() == 1) {
            day = "0" + day;
        }
        this.resultKey.set("yearMonthDay" + this.splitExpression + year + "-" + month + "-" + day);
        context.write((Object)this.resultKey, (Object)this.one);
        String hour = String.valueOf(this.cal.get(11));
        if (hour.length() == 1) {
            hour = "0" + hour;
        }
        this.resultKey.set("hour" + this.splitExpression + hour);
        context.write((Object)this.resultKey, (Object)this.one);
    }

    public static enum ErrorCases {
        DATENULL;

    }
}

