/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.analysis.histogram;

import eu.dicodeproject.analysis.histogram.DateHistogramMapper;
import eu.dicodeproject.analysis.histogram.DateHistogramReducer;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;

public class DateHistogramDriver
extends AbstractJob {
    public static final String splitExpression = "_";

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new DateHistogramDriver(), (String[])args);
    }

    public int run(String[] args) throws ClassNotFoundException, InterruptedException, IOException {
        String outputTable;
        String timeColumn;
        String dataFamily;
        this.addOption("inputTable", "i", "The hbase table holding our data.", "thtweets");
        this.addOption("family", "f", "The column family holding our data.", "d");
        this.addOption("column", "c", "The column qualifier holding our creationDate.", "creationDate");
        this.addOption("outputTable", "t", "The resulting hbase table in which the histogram is written.", "thtweets-creationDates");
        Map argMap = this.parseArguments(args);
        if (argMap == null) {
            return -1;
        }
        String inputTable = (String)argMap.get("--inputTable");
        boolean success = this.generateDateHistogramData(inputTable, dataFamily = (String)argMap.get("--family"), timeColumn = (String)argMap.get("--column"), outputTable = (String)argMap.get("--outputTable"));
        return success ? 0 : 1;
    }

    private boolean generateDateHistogramData(String inputTable, String dataFamily, String timeCol, String outputTable) throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = HBaseConfiguration.create();
        Job job = new Job(conf, "CreationDateDriver::GenerateHistogramData");
        job.setJarByClass(DateHistogramDriver.class);
        Scan scan = new Scan();
        scan.addColumn(Bytes.toBytes((String)dataFamily), Bytes.toBytes((String)timeCol));
        scan.setMaxVersions(1);
        TableMapReduceUtil.initTableMapperJob((String)inputTable, (Scan)scan, DateHistogramMapper.class, Text.class, IntWritable.class, (Job)job);
        TableMapReduceUtil.initTableReducerJob((String)outputTable, DateHistogramReducer.class, (Job)job);
        job.setNumReduceTasks(10);
        return job.waitForCompletion(true);
    }
}

