/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.analysis.hbase;

import eu.dicodeproject.analysis.hbase.HBaseDocumentProcessor;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.cli2.Option;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.lucene.analysis.Analyzer;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.vectorizer.DefaultAnalyzer;

public class HBaseLuceneTokenizerDriver
extends AbstractJob {
    private HBaseLuceneTokenizerDriver() {
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new HBaseLuceneTokenizerDriver(), (String[])args);
    }

    public int run(String[] args) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InterruptedException, IOException {
        this.addOutputOption();
        this.addOption((Option)DefaultOptionCreator.numReducersOption().create());
        this.addOption("analyzerName", "a", "The class name of the analyzer to use for preprocessing", null);
        this.addOption("table", "t", "The hbase table holding our data.", "twittertracker");
        this.addOption("family", "f", "The column family holding our data.", "textFamily");
        this.addOption("column", "c", "The column holding our data.", "text");
        Map argMap = this.parseArguments(args);
        if (argMap == null) {
            return -1;
        }
        Class<DefaultAnalyzer> analyzerClass = DefaultAnalyzer.class;
        if (argMap.get("--analyzerName") != null) {
            String className = (String)argMap.get("--analyzerName");
            analyzerClass = Class.forName(className).asSubclass(Analyzer.class);
            analyzerClass.newInstance();
        }
        String table = (String)argMap.get("--table");
        String family = (String)argMap.get("--family");
        String column = (String)argMap.get("--column");
        Path output = this.getOutputPath();
        Path tokenizedPath = new Path(output, "tokenized-documents");
        HBaseDocumentProcessor.tokenizeDocuments(table, family, column, analyzerClass, tokenizedPath);
        return 0;
    }
}

