/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.analysis.generic;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

public class GenericTableReducer
extends TableReducer<IntWritable, Text, ImmutableBytesWritable> {
    private static final String COLUMN = "result";
    private static final String FAMILY = "d";
    private static final String RESULT_ID = "resultId";
    private static final int LIMIT = 100;
    private int count = 0;
    private boolean flushed = false;
    private String dateKey;
    private JSONObject j;
    private List<Map<String, Integer>> entries;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        this.dateKey = context.getConfiguration().get(RESULT_ID).toLowerCase() + "_";
        this.dateKey = this.dateKey + df.format(new Date());
        this.j = new JSONObject();
        this.entries = new ArrayList<Map<String, Integer>>();
    }

    public void reduce(IntWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        long ct = key.get();
        for (Text val : values) {
            if (this.count >= 100) break;
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(val.toString(), (int)ct * -1);
            this.entries.add(entry);
            ++this.count;
        }
        if (this.count == 100 && !this.flushed) {
            this.writeData(context);
        }
    }

    private void writeData(Reducer.Context context) throws IOException, InterruptedException {
        try {
            this.j.put(COLUMN, this.entries);
            ImmutableBytesWritable dummy = new ImmutableBytesWritable(Bytes.toBytes((String)this.dateKey));
            Put put = new Put(Bytes.toBytes((String)this.dateKey));
            put.add(Bytes.toBytes((String)FAMILY), Bytes.toBytes((String)COLUMN), Bytes.toBytes((String)this.j.toString()));
            context.write((Object)dummy, (Object)put);
            this.flushed = true;
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
        if (!this.flushed) {
            this.writeData(context);
        }
    }
}

