/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.analysis.generic;

import eu.dicodeproject.analysis.generic.GenericTableReducer;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.cli2.Option;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.commandline.DefaultOptionCreator;

public final class GenericTableDriver
extends AbstractJob {
    private GenericTableDriver() {
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new GenericTableDriver(), (String[])args);
    }

    public int run(String[] args) throws ClassNotFoundException, InterruptedException, IOException {
        this.addOption((Option)DefaultOptionCreator.numReducersOption().create());
        this.addOption("input", "i", "The directory holding word/count pairs", "tmp");
        this.addOption("table", "t", "The hbase table storing the results.", "dummy-results");
        this.addOption("resultId", "r", "The result which will be the row prefix.", "");
        Map argMap = this.parseArguments(args);
        if (argMap == null) {
            return -1;
        }
        String input = (String)argMap.get("--input");
        String table = (String)argMap.get("--table");
        Configuration conf = HBaseConfiguration.create();
        conf.set("resultId", (String)argMap.get("--resultId"));
        Job job = new Job(conf);
        job.setJarByClass(GenericTableDriver.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(input));
        job.setJobName("HBaseDocumentProcessor::GenericTableWriter");
        job.setMapperClass(Mapper.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(Text.class);
        TableMapReduceUtil.initTableReducerJob((String)table, GenericTableReducer.class, (Job)job);
        job.setNumReduceTasks(1);
        job.waitForCompletion(true);
        return 0;
    }
}

