/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.analysis.generic;

import java.io.IOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class GenericMapper
extends TableMapper<Text, IntWritable> {
    private Text content = new Text();
    private static final IntWritable ONE = new IntWritable(1);
    private String separator = null;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        if (context.getConfiguration().get("separator") != null) {
            this.separator = context.getConfiguration().get("separator");
        }
    }

    protected void map(ImmutableBytesWritable row, Result values, Mapper.Context context) throws IOException, InterruptedException {
        for (KeyValue keyValue : values.list()) {
            if (this.separator != null) {
                String[] items;
                String field = new String(keyValue.getValue());
                for (String item : items = field.split(this.separator)) {
                    if (item.equals("")) continue;
                    this.content.set(item);
                    context.write((Object)this.content, (Object)ONE);
                }
                continue;
            }
            this.content.set(keyValue.getValue());
            context.write((Object)this.content, (Object)ONE);
        }
    }
}

