/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.analysis.examples;

import eu.dicodeproject.analysis.examples.MailContentHandler;
import java.io.IOException;
import org.apache.mahout.text.ChunkedWriter;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class UnquotedHandler
implements MailContentHandler {
    private final ChunkedWriter writer;
    private boolean inQuote = false;
    private String prefix;
    private StringBuilder builder;
    private int counter;

    public UnquotedHandler(ChunkedWriter writer) {
        this.writer = writer;
        this.counter = 0;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String targetKeyPrefix) {
        this.prefix = targetKeyPrefix;
    }

    @Override
    public void startDocument() throws SAXException {
        this.builder = new StringBuilder();
    }

    @Override
    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        String content = new String(arg0);
        if (!(content.startsWith("Content-Type") || content.startsWith("--") || this.inQuote)) {
            this.builder.append(content);
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
        if ("div".equals(arg1)) {
            ++this.counter;
            this.builder = new StringBuilder();
            this.inQuote = false;
        } else if ("q".equals(arg1)) {
            this.inQuote = true;
        }
    }

    @Override
    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        if ("div".equals(arg1)) {
            try {
                this.writer.write(this.prefix + "-" + this.counter, this.builder.toString());
            }
            catch (IOException e) {}
        } else if ("q".equals(arg1)) {
            this.inQuote = false;
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }
}

