/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class ZKTable {
    private static final Log LOG = LogFactory.getLog(ZKTable.class);
    private final ZooKeeperWatcher watcher;
    private final Map<String, TableState> cache = new HashMap<String, TableState>();

    public ZKTable(ZooKeeperWatcher zkw) throws KeeperException {
        this.watcher = zkw;
        this.populateTableStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateTableStates() throws KeeperException {
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            List<String> children = ZKUtil.listChildrenNoWatch(this.watcher, this.watcher.tableZNode);
            for (String child : children) {
                TableState state = ZKTable.getTableState(this.watcher, child);
                if (state == null) continue;
                this.cache.put(child, state);
            }
        }
    }

    private static TableState getTableState(ZooKeeperWatcher zkw, String child) throws KeeperException {
        String znode = ZKUtil.joinZNode(zkw.tableZNode, child);
        byte[] data = ZKUtil.getData(zkw, znode);
        if (data == null || data.length <= 0) {
            return null;
        }
        String str = Bytes.toString(data);
        try {
            return TableState.valueOf(str);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisabledTable(String tableName) throws KeeperException {
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            if (!this.isDisablingOrDisabledTable(tableName)) {
                LOG.warn((Object)("Moving table " + tableName + " state to disabled but was " + "not first in disabling state: " + (Object)((Object)this.cache.get(tableName))));
            }
            this.setTableState(tableName, TableState.DISABLED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisablingTable(String tableName) throws KeeperException {
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            if (!this.isEnabledOrDisablingTable(tableName)) {
                LOG.warn((Object)("Moving table " + tableName + " state to disabling but was " + "not first in enabled state: " + (Object)((Object)this.cache.get(tableName))));
            }
            this.setTableState(tableName, TableState.DISABLING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnablingTable(String tableName) throws KeeperException {
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            if (!this.isDisabledOrEnablingTable(tableName)) {
                LOG.warn((Object)("Moving table " + tableName + " state to disabling but was " + "not first in enabled state: " + (Object)((Object)this.cache.get(tableName))));
            }
            this.setTableState(tableName, TableState.ENABLING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTableState(String tableName, TableState state) throws KeeperException {
        String znode = ZKUtil.joinZNode(this.watcher.tableZNode, tableName);
        if (ZKUtil.checkExists(this.watcher, znode) == -1) {
            ZKUtil.createAndFailSilent(this.watcher, znode);
        }
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            ZKUtil.setData(this.watcher, znode, Bytes.toBytes(state.toString()));
            this.cache.put(tableName, state);
        }
    }

    public boolean isDisabledTable(String tableName) {
        return this.isTableState(tableName, TableState.DISABLED);
    }

    public static boolean isDisabledTable(ZooKeeperWatcher zkw, String tableName) throws KeeperException {
        TableState state = ZKTable.getTableState(zkw, tableName);
        return ZKTable.isTableState(TableState.DISABLED, state);
    }

    public boolean isDisablingTable(String tableName) {
        return this.isTableState(tableName, TableState.DISABLING);
    }

    public boolean isEnablingTable(String tableName) {
        return this.isTableState(tableName, TableState.ENABLING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabledTable(String tableName) {
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            return !this.cache.containsKey(tableName);
        }
    }

    public static boolean isEnabledTable(ZooKeeperWatcher zkw, String tableName) throws KeeperException {
        return ZKTable.getTableState(zkw, tableName) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisablingOrDisabledTable(String tableName) {
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            return this.isDisablingTable(tableName) || this.isDisabledTable(tableName);
        }
    }

    public static boolean isDisablingOrDisabledTable(ZooKeeperWatcher zkw, String tableName) throws KeeperException {
        TableState state = ZKTable.getTableState(zkw, tableName);
        return ZKTable.isTableState(TableState.DISABLING, state) || ZKTable.isTableState(TableState.DISABLED, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabledOrDisablingTable(String tableName) {
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            return this.isEnabledTable(tableName) || this.isDisablingTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisabledOrEnablingTable(String tableName) {
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            return this.isDisabledTable(tableName) || this.isEnablingTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTableState(String tableName, TableState state) {
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            TableState currentState = this.cache.get(tableName);
            return ZKTable.isTableState(currentState, state);
        }
    }

    private static boolean isTableState(TableState expectedState, TableState currentState) {
        return currentState != null && currentState.equals((Object)expectedState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabledTable(String tableName) throws KeeperException {
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            if (this.cache.remove(tableName) == null) {
                LOG.warn((Object)("Moving table " + tableName + " state to enabled but was " + "already enabled"));
            }
            ZKUtil.deleteNodeFailSilent(this.watcher, ZKUtil.joinZNode(this.watcher.tableZNode, tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getDisabledTables() {
        HashSet<String> disabledTables = new HashSet<String>();
        Map<String, TableState> map = this.cache;
        synchronized (map) {
            Set<String> tables = this.cache.keySet();
            for (String table : tables) {
                if (!this.isDisabledTable(table)) continue;
                disabledTables.add(table);
            }
        }
        return disabledTables;
    }

    public static Set<String> getDisabledTables(ZooKeeperWatcher zkw) throws KeeperException {
        HashSet<String> disabledTables = new HashSet<String>();
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, zkw.tableZNode);
        for (String child : children) {
            TableState state = ZKTable.getTableState(zkw, child);
            if (state != TableState.DISABLED) continue;
            disabledTables.add(child);
        }
        return disabledTables;
    }

    public static Set<String> getDisabledOrDisablingTables(ZooKeeperWatcher zkw) throws KeeperException {
        HashSet<String> disabledTables = new HashSet<String>();
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, zkw.tableZNode);
        for (String child : children) {
            TableState state = ZKTable.getTableState(zkw, child);
            if (state != TableState.DISABLED && state != TableState.DISABLING) continue;
            disabledTables.add(child);
        }
        return disabledTables;
    }

    public static enum TableState {
        ENABLED,
        DISABLED,
        DISABLING,
        ENABLING;

    }
}

