/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

public class RootRegionTracker
extends ZooKeeperNodeTracker {
    public RootRegionTracker(ZooKeeperWatcher watcher, Abortable abortable) {
        super(watcher, watcher.rootServerZNode, abortable);
    }

    public boolean isLocationAvailable() {
        return super.getData() != null;
    }

    public HServerAddress getRootRegionLocation() throws InterruptedException {
        return RootRegionTracker.dataToHServerAddress(super.getData());
    }

    public HServerAddress waitRootRegionLocation(long timeout) throws InterruptedException {
        return RootRegionTracker.dataToHServerAddress(super.blockUntilAvailable(timeout));
    }

    private static HServerAddress dataToHServerAddress(byte[] data) {
        return data == null ? null : new HServerAddress(Bytes.toString(data));
    }
}

