/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

public class MetaNodeTracker
extends ZooKeeperNodeTracker {
    private static final Log LOG = LogFactory.getLog(MetaNodeTracker.class);
    private final CatalogTracker catalogTracker;

    public MetaNodeTracker(ZooKeeperWatcher watcher, CatalogTracker catalogTracker, Abortable abortable) {
        super(watcher, ZKUtil.joinZNode(watcher.assignmentZNode, HRegionInfo.FIRST_META_REGIONINFO.getEncodedName()), abortable);
        this.catalogTracker = catalogTracker;
    }

    @Override
    public void nodeDeleted(String path) {
        super.nodeDeleted(path);
        if (!path.equals(this.node)) {
            return;
        }
        LOG.info((Object)"Detected completed assignment of META, notifying catalog tracker");
        try {
            this.catalogTracker.waitForMetaServerConnectionDefault();
        }
        catch (IOException e) {
            LOG.warn((Object)"Tried to reset META server location after seeing the completion of a new META assignment but got an IOE", (Throwable)e);
        }
    }
}

