/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.FileInputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.util.Hash;

public class JenkinsHash
extends Hash {
    private static long INT_MASK = 0xFFFFFFFFL;
    private static long BYTE_MASK = 255L;
    private static JenkinsHash _instance = new JenkinsHash();

    public static Hash getInstance() {
        return _instance;
    }

    private static long rot(long val, int pos) {
        return (long)Integer.rotateLeft((int)(val & INT_MASK), pos) & INT_MASK;
    }

    @Override
    public int hash(byte[] key, int off, int nbytes, int initval) {
        int length;
        long c;
        long b = c = 3735928559L + (long)length + (long)initval & INT_MASK;
        long a = c;
        int offset = off;
        for (length = nbytes; length > 12; length -= 12) {
            a = a + ((long)key[offset + 0] & BYTE_MASK) & INT_MASK;
            a = a + (((long)key[offset + 1] & BYTE_MASK) << 8 & INT_MASK) & INT_MASK;
            a = a + (((long)key[offset + 2] & BYTE_MASK) << 16 & INT_MASK) & INT_MASK;
            a = a + (((long)key[offset + 3] & BYTE_MASK) << 24 & INT_MASK) & INT_MASK;
            b = b + ((long)key[offset + 4] & BYTE_MASK) & INT_MASK;
            b = b + (((long)key[offset + 5] & BYTE_MASK) << 8 & INT_MASK) & INT_MASK;
            b = b + (((long)key[offset + 6] & BYTE_MASK) << 16 & INT_MASK) & INT_MASK;
            b = b + (((long)key[offset + 7] & BYTE_MASK) << 24 & INT_MASK) & INT_MASK;
            c = c + ((long)key[offset + 8] & BYTE_MASK) & INT_MASK;
            c = c + (((long)key[offset + 9] & BYTE_MASK) << 8 & INT_MASK) & INT_MASK;
            c = c + (((long)key[offset + 10] & BYTE_MASK) << 16 & INT_MASK) & INT_MASK;
            c = c + (((long)key[offset + 11] & BYTE_MASK) << 24 & INT_MASK) & INT_MASK;
            a = a - c & INT_MASK;
            a ^= JenkinsHash.rot(c, 4);
            c = c + b & INT_MASK;
            b = b - a & INT_MASK;
            b ^= JenkinsHash.rot(a, 6);
            a = a + c & INT_MASK;
            c = c - b & INT_MASK;
            c ^= JenkinsHash.rot(b, 8);
            b = b + a & INT_MASK;
            a = a - c & INT_MASK;
            a ^= JenkinsHash.rot(c, 16);
            c = c + b & INT_MASK;
            b = b - a & INT_MASK;
            b ^= JenkinsHash.rot(a, 19);
            a = a + c & INT_MASK;
            c = c - b & INT_MASK;
            c ^= JenkinsHash.rot(b, 4);
            b = b + a & INT_MASK;
            offset += 12;
        }
        switch (length) {
            case 12: {
                c = c + (((long)key[offset + 11] & BYTE_MASK) << 24 & INT_MASK) & INT_MASK;
            }
            case 11: {
                c = c + (((long)key[offset + 10] & BYTE_MASK) << 16 & INT_MASK) & INT_MASK;
            }
            case 10: {
                c = c + (((long)key[offset + 9] & BYTE_MASK) << 8 & INT_MASK) & INT_MASK;
            }
            case 9: {
                c = c + ((long)key[offset + 8] & BYTE_MASK) & INT_MASK;
            }
            case 8: {
                b = b + (((long)key[offset + 7] & BYTE_MASK) << 24 & INT_MASK) & INT_MASK;
            }
            case 7: {
                b = b + (((long)key[offset + 6] & BYTE_MASK) << 16 & INT_MASK) & INT_MASK;
            }
            case 6: {
                b = b + (((long)key[offset + 5] & BYTE_MASK) << 8 & INT_MASK) & INT_MASK;
            }
            case 5: {
                b = b + ((long)key[offset + 4] & BYTE_MASK) & INT_MASK;
            }
            case 4: {
                a = a + (((long)key[offset + 3] & BYTE_MASK) << 24 & INT_MASK) & INT_MASK;
            }
            case 3: {
                a = a + (((long)key[offset + 2] & BYTE_MASK) << 16 & INT_MASK) & INT_MASK;
            }
            case 2: {
                a = a + (((long)key[offset + 1] & BYTE_MASK) << 8 & INT_MASK) & INT_MASK;
            }
            case 1: {
                a = a + ((long)key[offset + 0] & BYTE_MASK) & INT_MASK;
                break;
            }
            case 0: {
                return (int)(c & INT_MASK);
            }
        }
        c ^= b;
        c = c - JenkinsHash.rot(b, 14) & INT_MASK;
        a ^= c;
        a = a - JenkinsHash.rot(c, 11) & INT_MASK;
        b ^= a;
        b = b - JenkinsHash.rot(a, 25) & INT_MASK;
        c ^= b;
        c = c - JenkinsHash.rot(b, 16) & INT_MASK;
        a ^= c;
        a = a - JenkinsHash.rot(c, 4) & INT_MASK;
        b ^= a;
        b = b - JenkinsHash.rot(a, 14) & INT_MASK;
        c ^= b;
        c = c - JenkinsHash.rot(b, 24) & INT_MASK;
        return (int)(c & INT_MASK);
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.err.println("Usage: JenkinsHash filename");
            System.exit(-1);
        }
        FileInputStream in = new FileInputStream(args[0]);
        byte[] bytes = new byte[512];
        int value = 0;
        JenkinsHash hash = new JenkinsHash();
        int length = in.read(bytes);
        while (length > 0) {
            value = hash.hash(bytes, length, value);
            length = in.read(bytes);
        }
        System.out.println(Math.abs(value));
    }
}

