/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Threads;

public class JVMClusterUtil {
    private static final Log LOG = LogFactory.getLog(JVMClusterUtil.class);

    public static RegionServerThread createRegionServerThread(Configuration c, Class<? extends HRegionServer> hrsc, int index) throws IOException {
        HRegionServer server;
        try {
            server = hrsc.getConstructor(Configuration.class).newInstance(c);
        }
        catch (InvocationTargetException ite) {
            Throwable target = ite.getTargetException();
            throw new RuntimeException("Failed construction of RegionServer: " + hrsc.toString() + (target.getCause() != null ? target.getCause().getMessage() : ""), target);
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        return new RegionServerThread(server, index);
    }

    public static MasterThread createMasterThread(Configuration c, Class<? extends HMaster> hmc, int index) throws IOException {
        HMaster server;
        try {
            server = hmc.getConstructor(Configuration.class).newInstance(c);
        }
        catch (InvocationTargetException ite) {
            Throwable target = ite.getTargetException();
            throw new RuntimeException("Failed construction of RegionServer: " + hmc.toString() + (target.getCause() != null ? target.getCause().getMessage() : ""), target);
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        return new MasterThread(server, index);
    }

    public static String startup(List<MasterThread> masters, List<RegionServerThread> regionservers) {
        if (masters != null) {
            for (MasterThread masterThread : masters) {
                masterThread.start();
            }
        }
        if (regionservers != null) {
            for (RegionServerThread regionServerThread : regionservers) {
                regionServerThread.start();
            }
        }
        if (masters == null || masters.isEmpty()) {
            return null;
        }
        while (true) {
            for (MasterThread masterThread : masters) {
                if (!masterThread.master.isActiveMaster()) continue;
                return masterThread.master.getMasterAddress().toString();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public static void shutdown(List<MasterThread> masters, List<RegionServerThread> regionservers) {
        LOG.debug((Object)"Shutting down HBase Cluster");
        if (masters != null) {
            for (MasterThread masterThread : masters) {
                if (masterThread.master.isActiveMaster()) {
                    masterThread.master.shutdown();
                    continue;
                }
                masterThread.master.stopMaster();
            }
        }
        for (RegionServerThread regionServerThread : regionservers) {
            if (!regionServerThread.isAlive()) continue;
            try {
                regionServerThread.join();
            }
            catch (InterruptedException e) {}
        }
        if (masters != null) {
            for (MasterThread masterThread : masters) {
                while (masterThread.master.isAlive()) {
                    try {
                        Threads.threadDumpingIsAlive(masterThread.master);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
        LOG.info((Object)("Shutdown of " + (masters != null ? Integer.valueOf(masters.size()) : "0") + " master(s) and " + (regionservers != null ? Integer.valueOf(regionservers.size()) : "0") + " regionserver(s) complete"));
    }

    public static class MasterThread
    extends Thread {
        private final HMaster master;

        public MasterThread(HMaster m, int index) {
            super((Runnable)m, "Master:" + index + ";" + m.getServerName());
            this.master = m;
        }

        public HMaster getMaster() {
            return this.master;
        }

        public void waitForServerOnline() {
            while (!this.master.isMasterRunning() && !this.master.isStopped()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static class RegionServerThread
    extends Thread {
        private final HRegionServer regionServer;

        public RegionServerThread(HRegionServer r, int index) {
            super((Runnable)r, "RegionServer:" + index + ";" + r.getServerName());
            this.regionServer = r;
        }

        public HRegionServer getRegionServer() {
            return this.regionServer;
        }

        public void waitForServerOnline() {
            while (!this.regionServer.isOnline() && !this.regionServer.isStopped()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

