/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.zookeeper.KeeperException;

public class HBaseFsckRepair {
    public static void fixDupeAssignment(Configuration conf, HRegionInfo region, List<HServerAddress> servers) throws IOException, KeeperException, InterruptedException {
        HRegionInfo actualRegion = new HRegionInfo(region);
        for (HServerAddress server : servers) {
            HBaseFsckRepair.closeRegionSilentlyAndWait(conf, server, actualRegion);
        }
        HBaseFsckRepair.forceOfflineInZK(conf, actualRegion);
    }

    public static void fixUnassigned(Configuration conf, HRegionInfo region) throws IOException, KeeperException {
        HRegionInfo actualRegion = new HRegionInfo(region);
        HBaseFsckRepair.forceOfflineInZK(conf, actualRegion);
    }

    private static void forceOfflineInZK(Configuration conf, HRegionInfo region) throws ZooKeeperConnectionException, KeeperException, IOException {
        ZKAssign.createOrForceNodeOffline(HConnectionManager.getConnection(conf).getZooKeeperWatcher(), region, "HBCKServerName");
    }

    protected static void closeRegionSilentlyAndWait(Configuration conf, HServerAddress server, HRegionInfo region) throws IOException, InterruptedException {
        HRegionInterface rs = HConnectionManager.getConnection(conf).getHRegionConnection(server);
        rs.closeRegion(region, false);
        long timeout = conf.getLong("hbase.hbck.close.timeout", 120000L);
        long expiration = timeout + System.currentTimeMillis();
        while (System.currentTimeMillis() < expiration) {
            try {
                HRegionInfo rsRegion = rs.getRegionInfo(region.getRegionName());
                if (rsRegion == null) {
                    throw new NotServingRegionException();
                }
            }
            catch (Exception e) {
                return;
            }
            Thread.sleep(1000L);
        }
        throw new IOException("Region " + (Object)((Object)region) + " failed to close within" + " timeout " + timeout);
    }
}

