/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.zookeeper.KeeperException;

public class OpenRegionHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(OpenRegionHandler.class);
    private final RegionServerServices rsServices;
    private final HRegionInfo regionInfo;
    private volatile int version = -1;

    public OpenRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo) {
        this(server, rsServices, regionInfo, EventHandler.EventType.M_RS_OPEN_REGION);
    }

    protected OpenRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo, EventHandler.EventType eventType) {
        super(server, eventType);
        this.rsServices = rsServices;
        this.regionInfo = regionInfo;
    }

    public HRegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() throws IOException {
        try {
            String name = this.regionInfo.getRegionNameAsString();
            LOG.debug((Object)("Processing open of " + name));
            if (this.server.isStopped() || this.rsServices.isStopping()) {
                LOG.info((Object)("Server stopping or stopped, skipping open of " + name));
                return;
            }
            String encodedName = this.regionInfo.getEncodedName();
            HRegion region = this.rsServices.getFromOnlineRegions(encodedName);
            if (region != null) {
                LOG.warn((Object)("Attempted open of " + name + " but already online on this server"));
                return;
            }
            if (!this.transitionZookeeperOfflineToOpening(encodedName)) {
                LOG.warn((Object)("Region was hijacked? It no longer exists, encodedName=" + encodedName));
                return;
            }
            region = this.openRegion();
            if (region == null) {
                return;
            }
            boolean failed = true;
            if (this.tickleOpening("post_region_open") && this.updateMeta(region)) {
                failed = false;
            }
            if (failed || this.server.isStopped() || this.rsServices.isStopping()) {
                this.cleanupFailedOpen(region);
                return;
            }
            if (!this.transitionToOpened(region)) {
                this.cleanupFailedOpen(region);
                return;
            }
            LOG.debug((Object)("Opened " + name));
        }
        finally {
            this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateMeta(HRegion r) {
        if (this.server.isStopped() || this.rsServices.isStopping()) {
            return false;
        }
        AtomicBoolean signaller = new AtomicBoolean(false);
        PostOpenDeployTasksThread t = new PostOpenDeployTasksThread(r, this.server, this.rsServices, signaller);
        t.start();
        int assignmentTimeout = this.server.getConfiguration().getInt("hbase.master.assignment.timeoutmonitor.period", 10000);
        long timeout = assignmentTimeout * 10;
        long now = System.currentTimeMillis();
        long endTime = now + timeout;
        long period = Math.max(1, assignmentTimeout / 3);
        long lastUpdate = now;
        while (!signaller.get() && t.isAlive() && !this.server.isStopped() && !this.rsServices.isStopping() && endTime > now) {
            long elapsed = now - lastUpdate;
            if (elapsed > period) {
                lastUpdate = now;
                this.tickleOpening("post_open_deploy");
            }
            AtomicBoolean atomicBoolean = signaller;
            synchronized (atomicBoolean) {
                try {
                    signaller.wait(period);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            now = System.currentTimeMillis();
        }
        if (t.isAlive()) {
            if (!signaller.get()) {
                LOG.debug((Object)("Interrupting thread " + t));
                t.interrupt();
            }
            try {
                t.join();
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)("Interrupted joining " + r.getRegionInfo().getRegionNameAsString()), (Throwable)ie);
                Thread.currentThread().interrupt();
            }
        }
        return !t.interrupted() && t.getException() == null;
    }

    private boolean transitionToOpened(HRegion r) throws IOException {
        boolean result = false;
        HRegionInfo hri = r.getRegionInfo();
        String name = hri.getRegionNameAsString();
        try {
            if (ZKAssign.transitionNodeOpened(this.server.getZooKeeper(), hri, this.server.getServerName(), this.version) == -1) {
                LOG.warn((Object)("Completed the OPEN of region " + name + " but when transitioning from " + " OPENING to OPENED got a version mismatch, someone else clashed " + "so now unassigning -- closing region"));
            } else {
                result = true;
            }
        }
        catch (KeeperException e) {
            LOG.error((Object)("Failed transitioning node " + name + " from OPENING to OPENED -- closing region"), (Throwable)e);
        }
        return result;
    }

    HRegion openRegion() {
        HRegion region = null;
        try {
            region = HRegion.openHRegion(this.regionInfo, this.rsServices.getWAL(), this.server.getConfiguration(), this.rsServices.getFlushRequester(), new CancelableProgressable(){

                @Override
                public boolean progress() {
                    return OpenRegionHandler.this.tickleOpening("open_region_progress");
                }
            });
        }
        catch (IOException e) {
            LOG.error((Object)("Failed open of region=" + this.regionInfo.getRegionNameAsString()), (Throwable)e);
        }
        return region;
    }

    private void cleanupFailedOpen(HRegion region) throws IOException {
        if (region != null) {
            region.close();
        }
        this.rsServices.removeFromOnlineRegions(this.regionInfo.getEncodedName());
    }

    boolean transitionZookeeperOfflineToOpening(String encodedName) {
        try {
            this.version = ZKAssign.transitionNodeOpening(this.server.getZooKeeper(), this.regionInfo, this.server.getServerName());
        }
        catch (KeeperException e) {
            LOG.error((Object)("Error transition from OFFLINE to OPENING for region=" + encodedName), (Throwable)e);
        }
        boolean b = this.isGoodVersion();
        if (!b) {
            LOG.warn((Object)("Failed transition from OFFLINE to OPENING for region=" + encodedName));
        }
        return b;
    }

    boolean tickleOpening(String context) {
        if (!this.isGoodVersion()) {
            return false;
        }
        String encodedName = this.regionInfo.getEncodedName();
        try {
            this.version = ZKAssign.retransitionNodeOpening(this.server.getZooKeeper(), this.regionInfo, this.server.getServerName(), this.version);
        }
        catch (KeeperException e) {
            this.server.abort("Exception refreshing OPENING; region=" + encodedName + ", context=" + context, e);
            this.version = -1;
        }
        boolean b = this.isGoodVersion();
        if (!b) {
            LOG.warn((Object)("Failed refreshing OPENING; region=" + encodedName + ", context=" + context));
        }
        return b;
    }

    private boolean isGoodVersion() {
        return this.version != -1;
    }

    static class PostOpenDeployTasksThread
    extends Thread {
        private Exception exception = null;
        private final Server server;
        private final RegionServerServices services;
        private final HRegion region;
        private final AtomicBoolean signaller;

        PostOpenDeployTasksThread(HRegion region, Server server, RegionServerServices services, AtomicBoolean signaller) {
            super("PostOpenDeployTasks:" + region.getRegionInfo().getEncodedName());
            this.setDaemon(true);
            this.server = server;
            this.services = services;
            this.region = region;
            this.signaller = signaller;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.services.postOpenDeployTasks(this.region, this.server.getCatalogTracker(), false);
            }
            catch (Exception e) {
                LOG.warn((Object)("Exception running postOpenDeployTasks; region=" + this.region.getRegionInfo().getEncodedName()), (Throwable)e);
                this.exception = e;
            }
            this.signaller.set(true);
            AtomicBoolean atomicBoolean = this.signaller;
            synchronized (atomicBoolean) {
                this.signaller.notify();
            }
        }

        Exception getException() {
            return this.exception;
        }
    }
}

