/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.BulkAssigner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.zookeeper.KeeperException;

public class EnableTableHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(EnableTableHandler.class);
    private final byte[] tableName;
    private final String tableNameStr;
    private final AssignmentManager assignmentManager;
    private final CatalogTracker ct;

    public EnableTableHandler(Server server, byte[] tableName, CatalogTracker catalogTracker, AssignmentManager assignmentManager) throws TableNotFoundException, IOException {
        super(server, EventHandler.EventType.C_M_ENABLE_TABLE);
        this.tableName = tableName;
        this.tableNameStr = Bytes.toString(tableName);
        this.ct = catalogTracker;
        this.assignmentManager = assignmentManager;
        if (!MetaReader.tableExists(catalogTracker, this.tableNameStr)) {
            throw new TableNotFoundException(Bytes.toString(tableName));
        }
    }

    @Override
    public void process() {
        try {
            LOG.info((Object)("Attemping to enable the table " + this.tableNameStr));
            this.handleEnableTable();
        }
        catch (IOException e) {
            LOG.error((Object)("Error trying to enable the table " + this.tableNameStr), (Throwable)e);
        }
        catch (KeeperException e) {
            LOG.error((Object)("Error trying to enable the table " + this.tableNameStr), (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private void handleEnableTable() throws IOException, KeeperException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<HRegionInfo> regionsToAssign(List<HRegionInfo> regionsInMeta) throws IOException {
        List<HRegionInfo> onlineRegions = this.assignmentManager.getRegionsOfTable(this.tableName);
        regionsInMeta.removeAll(onlineRegions);
        return regionsInMeta;
    }

    class BulkEnabler
    extends BulkAssigner {
        private final List<HRegionInfo> regions;
        private final int countOfRegionsInTable;

        BulkEnabler(Server server, List<HRegionInfo> regions, int countOfRegionsInTable) {
            super(server);
            this.regions = regions;
            this.countOfRegionsInTable = countOfRegionsInTable;
        }

        @Override
        protected void populatePool(ExecutorService pool) {
            for (HRegionInfo region : this.regions) {
                if (EnableTableHandler.this.assignmentManager.isRegionInTransition(region) != null) continue;
                final HRegionInfo hri = region;
                pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        EnableTableHandler.this.assignmentManager.assign(hri, true);
                    }
                });
            }
        }

        @Override
        protected boolean waitUntilDone(long timeout) throws InterruptedException {
            long startTime = System.currentTimeMillis();
            long remaining = timeout;
            List<HRegionInfo> regions = null;
            while (!EnableTableHandler.this.server.isStopped() && remaining > 0L) {
                Thread.sleep(EnableTableHandler.this.waitingTimeForEvents);
                regions = EnableTableHandler.this.assignmentManager.getRegionsOfTable(EnableTableHandler.this.tableName);
                if (this.isDone(regions)) break;
                remaining = timeout - (System.currentTimeMillis() - startTime);
            }
            return this.isDone(regions);
        }

        private boolean isDone(List<HRegionInfo> regions) {
            return regions != null && regions.size() >= this.countOfRegionsInTable;
        }
    }
}

