/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

class ActiveMasterManager
extends ZooKeeperListener {
    private static final Log LOG = LogFactory.getLog(ActiveMasterManager.class);
    final AtomicBoolean clusterHasActiveMaster = new AtomicBoolean(false);
    private final HServerAddress address;
    private final Server master;

    ActiveMasterManager(ZooKeeperWatcher watcher, HServerAddress address, Server master) {
        super(watcher);
        this.address = address;
        this.master = master;
    }

    @Override
    public void nodeCreated(String path) {
        if (path.equals(this.watcher.masterAddressZNode) && !this.master.isStopped()) {
            this.handleMasterNodeChange();
        }
    }

    @Override
    public void nodeDeleted(String path) {
        if (path.equals(this.watcher.masterAddressZNode) && !this.master.isStopped()) {
            this.handleMasterNodeChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMasterNodeChange() {
        try {
            AtomicBoolean atomicBoolean = this.clusterHasActiveMaster;
            synchronized (atomicBoolean) {
                if (ZKUtil.watchAndCheckExists(this.watcher, this.watcher.masterAddressZNode)) {
                    LOG.debug((Object)"A master is now available");
                    this.clusterHasActiveMaster.set(true);
                } else {
                    LOG.debug((Object)"No master available. Notifying waiting threads");
                    this.clusterHasActiveMaster.set(false);
                    this.clusterHasActiveMaster.notifyAll();
                }
            }
        }
        catch (KeeperException ke) {
            this.master.abort("Received an unexpected KeeperException, aborting", ke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean blockUntilBecomingActiveMaster() {
        boolean cleanSetOfActiveMaster = true;
        try {
            if (ZKUtil.setAddressAndWatch(this.watcher, this.watcher.masterAddressZNode, this.address)) {
                this.clusterHasActiveMaster.set(true);
                LOG.info((Object)("Master=" + this.address));
                return cleanSetOfActiveMaster;
            }
            cleanSetOfActiveMaster = false;
            this.clusterHasActiveMaster.set(true);
            HServerAddress currentMaster = ZKUtil.getDataAsAddress(this.watcher, this.watcher.masterAddressZNode);
            if (currentMaster != null && currentMaster.equals(this.address)) {
                LOG.info((Object)("Current master has this master's address, " + currentMaster + "; master was restarted?  Waiting on znode to expire..."));
                ZKUtil.deleteNode(this.watcher, this.watcher.masterAddressZNode);
            } else {
                LOG.info((Object)("Another master is the active master, " + currentMaster + "; waiting to become the next active master"));
            }
        }
        catch (KeeperException ke) {
            this.master.abort("Received an unexpected KeeperException, aborting", ke);
            return false;
        }
        AtomicBoolean atomicBoolean = this.clusterHasActiveMaster;
        synchronized (atomicBoolean) {
            while (this.clusterHasActiveMaster.get() && !this.master.isStopped()) {
                try {
                    this.clusterHasActiveMaster.wait();
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)"Interrupted waiting for master to die", (Throwable)e);
                }
            }
            if (this.master.isStopped()) {
                return cleanSetOfActiveMaster;
            }
            this.blockUntilBecomingActiveMaster();
        }
        return cleanSetOfActiveMaster;
    }

    public boolean isActiveMaster() {
        return this.clusterHasActiveMaster.get();
    }

    public void stop() {
        try {
            HServerAddress zkAddress = ZKUtil.getDataAsAddress(this.watcher, this.watcher.masterAddressZNode);
            if (zkAddress != null && zkAddress.equals(this.address)) {
                ZKUtil.deleteNode(this.watcher, this.watcher.masterAddressZNode);
            }
        }
        catch (KeeperException e) {
            LOG.error((Object)this.watcher.prefix("Error deleting our own master address node"), (Throwable)e);
        }
    }
}

