/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.Import;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;

public class CopyTable {
    static final String NAME = "copytable";
    static String rsClass = null;
    static String rsImpl = null;
    static long startTime = 0L;
    static long endTime = 0L;
    static String tableName = null;
    static String newTableName = null;
    static String peerAddress = null;
    static String families = null;

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        if (!CopyTable.doCommandLine(args)) {
            return null;
        }
        Job job = new Job(conf, "copytable_" + tableName);
        job.setJarByClass(CopyTable.class);
        Scan scan = new Scan();
        if (startTime != 0L) {
            scan.setTimeRange(startTime, endTime == 0L ? Long.MAX_VALUE : endTime);
        }
        if (families != null) {
            String[] fams;
            for (String fam : fams = families.split(",")) {
                scan.addFamily(Bytes.toBytes(fam));
            }
        }
        TableMapReduceUtil.initTableMapperJob(tableName, scan, Import.Importer.class, null, null, job);
        TableMapReduceUtil.initTableReducerJob(newTableName == null ? tableName : newTableName, null, job, null, peerAddress, rsClass, rsImpl);
        job.setNumReduceTasks(0);
        return job;
    }

    private static void printUsage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: CopyTable [--rs.class=CLASS] [--rs.impl=IMPL] [--starttime=X] [--endtime=Y] [--new.name=NEW] [--peer.adr=ADR] <tablename>");
        System.err.println();
        System.err.println("Options:");
        System.err.println(" rs.class     hbase.regionserver.class of the peer cluster");
        System.err.println("              specify if different from current cluster");
        System.err.println(" rs.impl      hbase.regionserver.impl of the peer cluster");
        System.err.println(" starttime    beginning of the time range");
        System.err.println("              without endtime means from starttime to forever");
        System.err.println(" endtime      end of the time range");
        System.err.println(" new.name     new table's name");
        System.err.println(" peer.adr     Address of the peer cluster given in the format");
        System.err.println("              hbase.zookeeer.quorum:hbase.zookeeper.client.port:zookeeper.znode.parent");
        System.err.println(" families     comma-seperated list of families to copy");
        System.err.println();
        System.err.println("Args:");
        System.err.println(" tablename    Name of the table to copy");
        System.err.println();
        System.err.println("Examples:");
        System.err.println(" To copy 'TestTable' to a cluster that uses replication for a 1 hour window:");
        System.err.println(" $ bin/hbase org.apache.hadoop.hbase.mapreduce.CopyTable --rs.class=org.apache.hadoop.hbase.ipc.ReplicationRegionInterface --rs.impl=org.apache.hadoop.hbase.regionserver.replication.ReplicationRegionServer --starttime=1265875194289 --endtime=1265878794289 --peer.adr=server1,server2,server3:2181:/hbase TestTable ");
    }

    private static boolean doCommandLine(String[] args) {
        if (args.length < 1) {
            CopyTable.printUsage(null);
            return false;
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                String cmd = args[i];
                if (cmd.equals("-h") || cmd.startsWith("--h")) {
                    CopyTable.printUsage(null);
                    return false;
                }
                String rsClassArgKey = "--rs.class=";
                if (cmd.startsWith("--rs.class=")) {
                    rsClass = cmd.substring("--rs.class=".length());
                    continue;
                }
                String rsImplArgKey = "--rs.impl=";
                if (cmd.startsWith("--rs.impl=")) {
                    rsImpl = cmd.substring("--rs.impl=".length());
                    continue;
                }
                String startTimeArgKey = "--starttime=";
                if (cmd.startsWith("--starttime=")) {
                    startTime = Long.parseLong(cmd.substring("--starttime=".length()));
                    continue;
                }
                String endTimeArgKey = "--endtime=";
                if (cmd.startsWith("--endtime=")) {
                    endTime = Long.parseLong(cmd.substring("--endtime=".length()));
                    continue;
                }
                String newNameArgKey = "--new.name=";
                if (cmd.startsWith("--new.name=")) {
                    newTableName = cmd.substring("--new.name=".length());
                    continue;
                }
                String peerAdrArgKey = "--peer.adr=";
                if (cmd.startsWith("--peer.adr=")) {
                    peerAddress = cmd.substring("--peer.adr=".length());
                    continue;
                }
                String familiesArgKey = "--families=";
                if (cmd.startsWith("--families=")) {
                    families = cmd.substring("--families=".length());
                    continue;
                }
                if (i != args.length - 1) continue;
                tableName = cmd;
            }
            if (newTableName == null && peerAddress == null) {
                CopyTable.printUsage("At least a new table name or a peer address must be specified");
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CopyTable.printUsage("Can't start because " + e.getMessage());
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        Job job = CopyTable.createSubmittableJob(conf, args);
        if (job != null) {
            System.exit(job.waitForCompletion(true) ? 0 : 1);
        }
    }
}

