/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    protected ByteBuffer buf;

    public ByteBufferOutputStream(int capacity) {
        this(capacity, false);
    }

    public ByteBufferOutputStream(int capacity, boolean useDirectByteBuffer) {
        this.buf = useDirectByteBuffer ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
    }

    public int size() {
        return this.buf.position();
    }

    public ByteBuffer getByteBuffer() {
        this.buf.flip();
        return this.buf;
    }

    private void checkSizeAndGrow(int extra) {
        if (this.buf.position() + extra > this.buf.limit()) {
            int newSize = (int)Math.min((long)this.buf.capacity() * 2L, Integer.MAX_VALUE);
            newSize = Math.max(newSize, this.buf.position() + extra);
            ByteBuffer newBuf = ByteBuffer.allocate(newSize);
            this.buf.flip();
            newBuf.put(this.buf);
            this.buf = newBuf;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkSizeAndGrow(1);
        this.buf.put((byte)b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.checkSizeAndGrow(b.length);
        this.buf.put(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkSizeAndGrow(len);
        this.buf.put(b, off, len);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

