/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.io.Writable;

public class Reference
implements Writable {
    private byte[] splitkey;
    private Range region;

    public Reference(byte[] splitRow, Range fr) {
        this.splitkey = splitRow == null ? null : KeyValue.createFirstOnRow(splitRow).getKey();
        this.region = fr;
    }

    public Reference() {
        this(null, Range.bottom);
    }

    public Range getFileRegion() {
        return this.region;
    }

    public byte[] getSplitKey() {
        return this.splitkey;
    }

    public String toString() {
        return "" + (Object)((Object)this.region);
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(Reference.isTopFileRegion(this.region));
        Bytes.writeByteArray(out, this.splitkey);
    }

    public void readFields(DataInput in) throws IOException {
        boolean tmp = in.readBoolean();
        this.region = tmp ? Range.top : Range.bottom;
        this.splitkey = Bytes.readByteArray(in);
    }

    public static boolean isTopFileRegion(Range r) {
        return r.equals((Object)Range.top);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path write(FileSystem fs, Path p) throws IOException {
        FSUtils.create(fs, p);
        FSDataOutputStream out = fs.create(p);
        try {
            this.write((DataOutput)out);
        }
        finally {
            out.close();
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Reference read(FileSystem fs, Path p) throws IOException {
        FSDataInputStream in = fs.open(p);
        try {
            Reference r = new Reference();
            r.readFields((DataInput)in);
            Reference reference = r;
            return reference;
        }
        finally {
            in.close();
        }
    }

    public static enum Range {
        top,
        bottom;

    }
}

