/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;

public class ColumnCountGetFilter
extends FilterBase {
    private int limit = 0;
    private int count = 0;

    public ColumnCountGetFilter() {
    }

    public ColumnCountGetFilter(int n) {
        this.limit = n;
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public boolean filterAllRemaining() {
        return this.count > this.limit;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue v) {
        ++this.count;
        return this.filterAllRemaining() ? Filter.ReturnCode.SKIP : Filter.ReturnCode.INCLUDE;
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    public void readFields(DataInput in) throws IOException {
        this.limit = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.limit);
    }
}

