/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.executor;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;

public class RegionTransitionData
implements Writable {
    private EventHandler.EventType eventType;
    private byte[] regionName;
    private String serverName;
    private long stamp;

    public RegionTransitionData() {
    }

    public RegionTransitionData(EventHandler.EventType eventType, byte[] regionName) {
        this(eventType, regionName, null);
    }

    public RegionTransitionData(EventHandler.EventType eventType, byte[] regionName, String serverName) {
        this.eventType = eventType;
        this.stamp = System.currentTimeMillis();
        this.regionName = regionName;
        this.serverName = serverName;
    }

    public EventHandler.EventType getEventType() {
        return this.eventType;
    }

    public byte[] getRegionName() {
        return this.regionName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public long getStamp() {
        return this.stamp;
    }

    public void readFields(DataInput in) throws IOException {
        this.eventType = EventHandler.EventType.values()[in.readShort()];
        this.stamp = in.readLong();
        this.regionName = Bytes.readByteArray(in);
        this.serverName = in.readBoolean() ? in.readUTF() : null;
    }

    public void write(DataOutput out) throws IOException {
        out.writeShort(this.eventType.ordinal());
        out.writeLong(System.currentTimeMillis());
        Bytes.writeByteArray(out, this.regionName);
        out.writeBoolean(this.serverName != null);
        if (this.serverName != null) {
            out.writeUTF(this.serverName);
        }
    }

    public byte[] getBytes() {
        try {
            return Writables.getBytes(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static RegionTransitionData fromBytes(byte[] bytes) {
        try {
            RegionTransitionData data = new RegionTransitionData();
            Writables.getWritable(bytes, data);
            return data;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "region=" + Bytes.toString(this.regionName) + ", server=" + this.serverName + ", state=" + (Object)((Object)this.eventType);
    }
}

