/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.util.Sleeper;

public abstract class Chore
extends Thread {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private final Sleeper sleeper;
    protected final Stoppable stopper;

    public Chore(String name, int p, Stoppable stopper) {
        super(name);
        this.sleeper = new Sleeper(p, stopper);
        this.stopper = stopper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            boolean initialChoreComplete = false;
            while (!this.stopper.isStopped()) {
                long startTime = System.currentTimeMillis();
                try {
                    if (!initialChoreComplete) {
                        initialChoreComplete = this.initialChore();
                    } else {
                        this.chore();
                    }
                }
                catch (Exception e) {
                    this.LOG.error((Object)"Caught exception", (Throwable)e);
                    if (this.stopper.isStopped()) continue;
                }
                this.sleeper.sleep(startTime);
            }
        }
        catch (Throwable t) {
            this.LOG.fatal((Object)(this.getName() + "error"), t);
        }
        finally {
            this.LOG.info((Object)(this.getName() + " exiting"));
        }
    }

    public void triggerNow() {
        this.sleeper.skipSleepCycle();
    }

    protected boolean initialChore() {
        return true;
    }

    protected abstract void chore();

    protected void sleep() {
        this.sleeper.sleep();
    }
}

