/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.FloatFunction;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.function.IntFloatProcedure;
import org.apache.mahout.math.function.IntProcedure;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.set.AbstractSet;

public abstract class AbstractIntFloatMap
extends AbstractSet {
    public boolean containsKey(final int key) {
        return !this.forEachKey(new IntProcedure(){

            public boolean apply(int iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final float value) {
        return !this.forEachPair(new IntFloatProcedure(){

            public boolean apply(int iterKey, float iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractIntFloatMap copy() {
        return (AbstractIntFloatMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractIntFloatMap)) {
            return false;
        }
        final AbstractIntFloatMap other = (AbstractIntFloatMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new IntFloatProcedure(){

            public boolean apply(int key, float value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new IntFloatProcedure(){

            public boolean apply(int key, float value) {
                return AbstractIntFloatMap.this.containsKey(key) && AbstractIntFloatMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(IntProcedure var1);

    public boolean forEachPair(final IntFloatProcedure procedure) {
        return this.forEachKey(new IntProcedure(){

            public boolean apply(int key) {
                return procedure.apply(key, AbstractIntFloatMap.this.get(key));
            }
        });
    }

    public abstract float get(int var1);

    public IntArrayList keys() {
        IntArrayList list = new IntArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final IntArrayList list) {
        list.clear();
        this.forEachKey(new IntProcedure(){

            public boolean apply(int key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(IntArrayList keyList) {
        this.pairsSortedByValue(keyList, new FloatArrayList(this.size()));
    }

    public void pairsMatching(final IntFloatProcedure condition, final IntArrayList keyList, final FloatArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new IntFloatProcedure(){

            public boolean apply(int key, float value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(IntArrayList keyList, FloatArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(IntArrayList keyList, FloatArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final int[] k = keyList.elements();
        final float[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                float t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                int t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(int var1, float var2);

    public abstract boolean removeKey(int var1);

    public String toString() {
        IntArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            int key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        IntArrayList theKeys = new IntArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            int key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public FloatArrayList values() {
        FloatArrayList list = new FloatArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final FloatArrayList list) {
        list.clear();
        this.forEachKey(new IntProcedure(){

            public boolean apply(int key) {
                list.add(AbstractIntFloatMap.this.get(key));
                return true;
            }
        });
    }

    public void assign(final FloatFunction function) {
        this.copy().forEachPair(new IntFloatProcedure(){

            public boolean apply(int key, float value) {
                AbstractIntFloatMap.this.put(key, function.apply(value));
                return true;
            }
        });
    }

    public void assign(AbstractIntFloatMap other) {
        this.clear();
        other.forEachPair(new IntFloatProcedure(){

            public boolean apply(int key, float value) {
                AbstractIntFloatMap.this.put(key, value);
                return true;
            }
        });
    }

    public float adjustOrPutValue(int key, float newValue, float incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = this.get(key) + incrValue;
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

