/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.io;

import java.util.Map;
import java.util.TreeMap;

public class BytesProgressWatcher {
    public static final int SECONDS_OF_HISTORY = 5;
    private boolean isStarted = false;
    private long bytesToTransfer = 0L;
    private long startTimeAllTransfersMS = -1L;
    private long totalBytesInAllTransfers = 0L;
    private long startTimeCurrentTransferMS = -1L;
    private long totalBytesInCurrentTransfer = 0L;
    private long endTimeCurrentTransferMS = -1L;
    private Map historyOfBytesBySecond = new TreeMap();
    private long earliestHistorySecond = Long.MAX_VALUE;

    public BytesProgressWatcher(long bytesToTransfer) {
        this.bytesToTransfer = bytesToTransfer;
    }

    public long getBytesToTransfer() {
        return this.bytesToTransfer;
    }

    public void resetWatcher() {
        this.startTimeCurrentTransferMS = System.currentTimeMillis();
        if (this.startTimeAllTransfersMS == -1L) {
            this.startTimeAllTransfersMS = this.startTimeCurrentTransferMS;
        }
        this.endTimeCurrentTransferMS = -1L;
        this.totalBytesInCurrentTransfer = 0L;
        this.isStarted = true;
    }

    public synchronized void updateBytesTransferred(long byteCount) {
        Long currentSecond;
        Long bytesInSecond;
        if (!this.isStarted) {
            this.resetWatcher();
        }
        this.totalBytesInCurrentTransfer += byteCount;
        this.totalBytesInAllTransfers += byteCount;
        if (this.totalBytesInCurrentTransfer >= this.bytesToTransfer) {
            this.endTimeCurrentTransferMS = System.currentTimeMillis();
        }
        if ((bytesInSecond = (Long)this.historyOfBytesBySecond.get(currentSecond = new Long(System.currentTimeMillis() / 1000L))) != null) {
            this.historyOfBytesBySecond.put(currentSecond, new Long(byteCount + bytesInSecond));
        } else {
            this.historyOfBytesBySecond.put(currentSecond, new Long(byteCount));
        }
        if (currentSecond < this.earliestHistorySecond) {
            this.earliestHistorySecond = currentSecond;
        }
        long removeHistoryBeforeSecond = currentSecond - 5L;
        for (long sec = this.earliestHistorySecond; sec < removeHistoryBeforeSecond; ++sec) {
            this.historyOfBytesBySecond.remove(new Long(sec));
        }
        this.earliestHistorySecond = removeHistoryBeforeSecond;
    }

    public long getBytesTransferred() {
        return this.totalBytesInCurrentTransfer;
    }

    public long getBytesRemaining() {
        return this.bytesToTransfer - this.totalBytesInCurrentTransfer;
    }

    public long getRemainingTime() {
        BytesProgressWatcher[] progressWatchers = new BytesProgressWatcher[]{this};
        long bytesRemaining = this.bytesToTransfer - this.totalBytesInCurrentTransfer;
        double remainingSecs = (double)bytesRemaining / BytesProgressWatcher.calculateOverallBytesPerSecond(progressWatchers);
        return Math.round(remainingSecs);
    }

    public synchronized double getRecentByteRatePerSecond() {
        long endSecond;
        if (!this.isStarted) {
            return 0.0;
        }
        long currentSecond = System.currentTimeMillis() / 1000L;
        long startSecond = 1L + (currentSecond - 5L);
        long l = endSecond = this.endTimeCurrentTransferMS != -1L ? this.endTimeCurrentTransferMS / 1000L : currentSecond;
        if (currentSecond - 5L > endSecond) {
            this.historyOfBytesBySecond.clear();
            return 0.0;
        }
        long sumOfBytes = 0L;
        long numberOfSecondsInHistory = 0L;
        for (long sec = startSecond; sec <= endSecond; ++sec) {
            ++numberOfSecondsInHistory;
            Long bytesInSecond = (Long)this.historyOfBytesBySecond.get(new Long(sec));
            if (bytesInSecond == null) continue;
            sumOfBytes += bytesInSecond.longValue();
        }
        return numberOfSecondsInHistory == 0L ? 0.0 : (double)sumOfBytes / (double)numberOfSecondsInHistory;
    }

    protected long getElapsedTimeMS() {
        if (!this.isStarted) {
            return 0L;
        }
        if (this.endTimeCurrentTransferMS != -1L) {
            return this.endTimeCurrentTransferMS - this.startTimeCurrentTransferMS;
        }
        return System.currentTimeMillis() - this.startTimeCurrentTransferMS;
    }

    protected long getTotalBytesInAllTransfers() {
        return this.totalBytesInAllTransfers;
    }

    protected boolean isStarted() {
        return this.isStarted;
    }

    protected long getHistoricStartTimeMS() {
        return this.startTimeAllTransfersMS;
    }

    public static long sumBytesToTransfer(BytesProgressWatcher[] progressWatchers) {
        long sumOfBytes = 0L;
        for (int i = 0; i < progressWatchers.length; ++i) {
            sumOfBytes += progressWatchers[i].getBytesToTransfer();
        }
        return sumOfBytes;
    }

    public static long sumBytesTransferred(BytesProgressWatcher[] progressWatchers) {
        long sumOfBytes = 0L;
        for (int i = 0; i < progressWatchers.length; ++i) {
            sumOfBytes += progressWatchers[i].getBytesTransferred();
        }
        return sumOfBytes;
    }

    public static long calculateRemainingTime(BytesProgressWatcher[] progressWatchers) {
        long bytesRemaining = BytesProgressWatcher.sumBytesToTransfer(progressWatchers) - BytesProgressWatcher.sumBytesTransferred(progressWatchers);
        double bytesPerSecond = BytesProgressWatcher.calculateOverallBytesPerSecond(progressWatchers);
        if (Math.abs(bytesPerSecond) < 0.001) {
            return 0L;
        }
        double remainingSecs = (double)bytesRemaining / bytesPerSecond;
        return Math.round(remainingSecs);
    }

    public static double calculateOverallBytesPerSecond(BytesProgressWatcher[] progressWatchers) {
        long initialStartTime = Long.MAX_VALUE;
        long bytesTotal = 0L;
        for (int i = 0; i < progressWatchers.length; ++i) {
            if (!progressWatchers[i].isStarted()) continue;
            bytesTotal += progressWatchers[i].getTotalBytesInAllTransfers();
            if (progressWatchers[i].getHistoricStartTimeMS() >= initialStartTime) continue;
            initialStartTime = progressWatchers[i].getHistoricStartTimeMS();
        }
        long elapsedTimeSecs = (System.currentTimeMillis() - initialStartTime) / 1000L;
        double bytesPerSecondOverall = elapsedTimeSecs == 0L ? (double)bytesTotal : (double)bytesTotal / (double)elapsedTimeSecs;
        return bytesPerSecondOverall;
    }

    public static long calculateRecentByteRatePerSecond(BytesProgressWatcher[] progressWatchers) {
        double sumOfRates = 0.0;
        for (int i = 0; i < progressWatchers.length; ++i) {
            if (!progressWatchers[i].isStarted()) continue;
            sumOfRates += progressWatchers[i].getRecentByteRatePerSecond();
        }
        return Math.round(sumOfRates);
    }
}

