/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.twitterstream.source;

import com.google.common.base.Preconditions;
import eu.dicodeproject.twitterstream.source.TweetSource;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.StatusListener;
import twitter4j.TwitterStream;
import twitter4j.TwitterStreamFactory;
import twitter4j.conf.ConfigurationBuilder;

public class TweetSamplingStream
implements TweetSource,
StatusListener {
    private static final Logger LOG = LoggerFactory.getLogger(TweetSamplingStream.class);
    private final TweetSamplingStreamIterator iterator = new TweetSamplingStreamIterator();
    private BlockingQueue<Status> tweetQueue;
    private final AtomicInteger failures = new AtomicInteger(0);
    private String streamConsumerkey;
    private String streamConsumersecret;
    private String streamAccesstoken;
    private String streamAccesstokensecret;
    private int streamTweetReceiveTimeout = 100;
    private int streamTweetTakeTimeout = 10;
    private int streamTweetQueueSize = 200;
    private int streamTweetErrorThreshold = 300;

    @Override
    public void triggerHarvesting() {
        Preconditions.checkNotNull((Object)this.streamConsumerkey, (Object)"streamConsumerkey missing!");
        Preconditions.checkNotNull((Object)this.streamConsumersecret, (Object)"streamConsumersecret missing!");
        Preconditions.checkNotNull((Object)this.streamAccesstoken, (Object)"streamAccesstoken missing!");
        Preconditions.checkNotNull((Object)this.streamAccesstokensecret, (Object)"streamAccesstokensecret missing!");
        this.initQueue();
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.setOAuthAccessToken(this.streamAccesstoken);
        cb.setOAuthAccessTokenSecret(this.streamAccesstokensecret);
        cb.setOAuthConsumerKey(this.streamConsumerkey);
        cb.setOAuthConsumerSecret(this.streamConsumersecret);
        TwitterStream twitterStream = new TwitterStreamFactory(cb.build()).getInstance();
        twitterStream.addListener((StatusListener)this);
        twitterStream.sample();
    }

    void initQueue() {
        this.tweetQueue = new LinkedBlockingQueue<Status>(this.streamTweetQueueSize);
    }

    @Override
    public Iterator<Status> iterator() {
        return this.iterator;
    }

    public void onStatus(Status status) {
        try {
            if (!this.tweetQueue.offer(status, this.streamTweetReceiveTimeout, TimeUnit.SECONDS)) {
                LOG.warn("Failed to add current tweet content to queue: Dropping as queue seems full.");
            }
        }
        catch (InterruptedException e) {
            this.failures.incrementAndGet();
            LOG.warn("Could not process current tweet due to exception. Increasing failure count by one and continuing to process. " + e.getMessage());
        }
    }

    public void onDeletionNotice(StatusDeletionNotice statusDeletionNotice) {
    }

    public void onTrackLimitationNotice(int numberOfLimitedStatuses) {
    }

    public void onException(Exception e) {
        this.failures.incrementAndGet();
    }

    public void onScrubGeo(long arg0, long arg1) {
    }

    public void setStreamConsumerkey(String streamConsumerkey) {
        this.streamConsumerkey = streamConsumerkey;
    }

    public void setStreamConsumersecret(String streamConsumersecret) {
        this.streamConsumersecret = streamConsumersecret;
    }

    public void setStreamAccesstoken(String streamAccesstoken) {
        this.streamAccesstoken = streamAccesstoken;
    }

    public void setStreamAccesstokensecret(String streamAccesstokensecret) {
        this.streamAccesstokensecret = streamAccesstokensecret;
    }

    public void setStreamTweetReceiveTimeout(int streamTweetReceiveTimeout) {
        this.streamTweetReceiveTimeout = streamTweetReceiveTimeout;
    }

    public void setStreamTweetTakeTimeout(int streamTweetTakeTimeout) {
        this.streamTweetTakeTimeout = streamTweetTakeTimeout;
    }

    public void setStreamTweetQueueSize(int streamTweetQueueSize) {
        this.streamTweetQueueSize = streamTweetQueueSize;
    }

    public void setStreamTweetErrorThreshold(int streamTweetErrorThreshold) {
        this.streamTweetErrorThreshold = streamTweetErrorThreshold;
    }

    private class TweetSamplingStreamIterator
    implements Iterator<Status> {
        private TweetSamplingStreamIterator() {
        }

        @Override
        public boolean hasNext() {
            if (TweetSamplingStream.this.failures.get() >= TweetSamplingStream.this.streamTweetErrorThreshold) {
                LOG.error("Stopping twitter streaming. Too many errors: " + TweetSamplingStream.this.failures);
            }
            return TweetSamplingStream.this.failures.get() < TweetSamplingStream.this.streamTweetErrorThreshold;
        }

        @Override
        public Status next() {
            try {
                return (Status)TweetSamplingStream.this.tweetQueue.poll(TweetSamplingStream.this.streamTweetTakeTimeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.info("Failed to retrieve any tweets in " + TweetSamplingStream.this.streamTweetTakeTimeout + " seconds. Increasing failure counter by one.");
                TweetSamplingStream.this.failures.incrementAndGet();
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove on twitter streams not possible.");
        }
    }
}

