/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.twitterstream;

import eu.dicodeproject.twitterstream.sink.TweetSink;
import eu.dicodeproject.twitterstream.source.TweetSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import twitter4j.Status;

public class StreamingBroker {
    private final Iterator<Status> sourceIt;
    private final TweetSink sink;
    private final ExecutorService executor;
    private boolean routing = false;
    private List<Future<Boolean>> results = new ArrayList<Future<Boolean>>();
    private TweetSource source;
    private int streamBrokerPoolSize;

    public StreamingBroker(TweetSource source, TweetSink sink, int streamBrokerPoolSize) {
        this.sink = sink;
        this.source = source;
        this.sourceIt = source.iterator();
        this.executor = Executors.newFixedThreadPool(streamBrokerPoolSize);
        this.streamBrokerPoolSize = streamBrokerPoolSize;
    }

    public StreamingBroker(TweetSource source, TweetSink sink) {
        this(source, sink, 10);
    }

    public synchronized void start() {
        this.source.triggerHarvesting();
        if (!this.routing) {
            int threadNum = this.streamBrokerPoolSize;
            for (int i = 0; i < threadNum; ++i) {
                Future<Boolean> result = this.executor.submit(new Plane(this.sourceIt, this.sink));
                this.results.add(result);
            }
            this.routing = true;
        }
    }

    public synchronized void stop() {
        if (this.routing) {
            for (Future<Boolean> future : this.results) {
                future.cancel(true);
            }
        }
    }

    public boolean busy() {
        for (Future<Boolean> result : this.results) {
            if (result.isDone() || result.isCancelled()) continue;
            return true;
        }
        return false;
    }

    private static final class Plane
    implements Callable<Boolean> {
        private final Iterator<Status> source;
        private final TweetSink sink;

        public Plane(Iterator<Status> source, TweetSink sink) {
            this.source = source;
            this.sink = sink;
        }

        @Override
        public Boolean call() throws InterruptedException, IOException {
            while (this.source.hasNext()) {
                Status status = this.source.next();
                if (status != null) {
                    this.sink.store(status);
                }
                Thread.sleep(200L);
            }
            return Boolean.TRUE;
        }
    }
}

