/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.QueryMaker;
import org.apache.lucene.benchmark.byTask.tasks.BenchmarkHighlighter;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReadTask
extends PerfTask {
    private final QueryMaker queryMaker = this.withSearch() ? this.getQueryMaker() : null;
    static final int DEFAULT_SEARCH_NUM_HITS = 10;
    private int numHits;

    public ReadTask(PerfRunData runData) {
        super(runData);
    }

    @Override
    public int doLogic() throws Exception {
        boolean closeSearcher;
        IndexReader reader;
        int res = 0;
        IndexSearcher searcher = this.getRunData().getIndexSearcher();
        if (searcher == null) {
            Directory dir = this.getRunData().getDirectory();
            reader = IndexReader.open((Directory)dir, (boolean)true);
            searcher = new IndexSearcher(reader);
            closeSearcher = true;
        } else {
            reader = searcher.getIndexReader();
            closeSearcher = false;
        }
        if (this.withWarm()) {
            Document doc = null;
            for (int m = 0; m < reader.maxDoc(); ++m) {
                if (reader.isDeleted(m)) continue;
                doc = reader.document(m);
                res += doc == null ? 0 : 1;
            }
        }
        if (this.withSearch()) {
            ++res;
            Query q = this.queryMaker.makeQuery();
            Sort sort = this.getSort();
            TopDocs hits = null;
            int numHits = this.numHits();
            if (numHits > 0) {
                ScoreDoc[] scoreDocs;
                int traversalSize;
                if (!this.withCollector()) {
                    if (sort != null) {
                        Weight w = q.weight((Searcher)searcher);
                        TopFieldCollector collector = TopFieldCollector.create((Sort)sort, (int)numHits, (boolean)true, (boolean)this.withScore(), (boolean)this.withMaxScore(), (!w.scoresDocsOutOfOrder() ? 1 : 0) != 0);
                        searcher.search(w, null, (Collector)collector);
                        hits = collector.topDocs();
                    } else {
                        hits = searcher.search(q, numHits);
                    }
                } else {
                    Collector collector = this.createCollector();
                    searcher.search(q, null, collector);
                }
                String printHitsField = this.getRunData().getConfig().get("print.hits.field", null);
                if (hits != null && printHitsField != null && printHitsField.length() > 0) {
                    if (q instanceof MultiTermQuery) {
                        System.out.println("MultiTermQuery term count = " + ((MultiTermQuery)q).getTotalNumberOfTerms());
                    }
                    System.out.println("totalHits = " + hits.totalHits);
                    System.out.println("maxDoc()  = " + reader.maxDoc());
                    System.out.println("numDocs() = " + reader.numDocs());
                    for (int i = 0; i < hits.scoreDocs.length; ++i) {
                        int docID = hits.scoreDocs[i].doc;
                        Document doc = reader.document(docID);
                        System.out.println("  " + i + ": doc=" + docID + " score=" + hits.scoreDocs[i].score + " " + printHitsField + " =" + doc.get(printHitsField));
                    }
                }
                if (this.withTraverse() && (traversalSize = Math.min((scoreDocs = hits.scoreDocs).length, this.traversalSize())) > 0) {
                    boolean retrieve = this.withRetrieve();
                    int numHighlight = Math.min(this.numToHighlight(), scoreDocs.length);
                    Analyzer analyzer = this.getRunData().getAnalyzer();
                    BenchmarkHighlighter highlighter = null;
                    if (numHighlight > 0) {
                        highlighter = this.getBenchmarkHighlighter(q);
                    }
                    for (int m = 0; m < traversalSize; ++m) {
                        int id = scoreDocs[m].doc;
                        ++res;
                        if (!retrieve) continue;
                        Document document = this.retrieveDoc(reader, id);
                        res += document != null ? 1 : 0;
                        if (numHighlight <= 0 || m >= numHighlight) continue;
                        Collection<String> fieldsToHighlight = this.getFieldsToHighlight(document);
                        for (String field : fieldsToHighlight) {
                            String text = document.get(field);
                            res += highlighter.doHighlight(reader, id, field, document, analyzer, text);
                        }
                    }
                }
            }
        }
        if (closeSearcher) {
            searcher.close();
            reader.close();
        } else {
            reader.decRef();
        }
        return res;
    }

    protected Collector createCollector() throws Exception {
        return TopScoreDocCollector.create((int)this.numHits(), (boolean)true);
    }

    protected Document retrieveDoc(IndexReader ir, int id) throws IOException {
        return ir.document(id);
    }

    public abstract QueryMaker getQueryMaker();

    public abstract boolean withSearch();

    public boolean withCollector() {
        return false;
    }

    public abstract boolean withWarm();

    public abstract boolean withTraverse();

    public boolean withScore() {
        return true;
    }

    public boolean withMaxScore() {
        return true;
    }

    public int traversalSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        this.numHits = this.getRunData().getConfig().get("search.num.hits", 10);
    }

    public int numHits() {
        return this.numHits;
    }

    public abstract boolean withRetrieve();

    public int numToHighlight() {
        return 0;
    }

    protected BenchmarkHighlighter getBenchmarkHighlighter(Query q) {
        return null;
    }

    protected Sort getSort() {
        return null;
    }

    protected Collection<String> getFieldsToHighlight(Document document) {
        List fieldables = document.getFields();
        HashSet<String> result = new HashSet<String>(fieldables.size());
        for (Fieldable fieldable : fieldables) {
            result.add(fieldable.name());
        }
        return result;
    }
}

