/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.util.ArrayUtil;

public class NearRealtimeReaderTask
extends PerfTask {
    long pauseMSec = 3000L;
    int reopenCount;
    int[] reopenTimes = new int[1];

    public NearRealtimeReaderTask(PerfRunData runData) {
        super(runData);
    }

    public int doLogic() throws Exception {
        PerfRunData runData = this.getRunData();
        IndexWriter w = runData.getIndexWriter();
        if (w == null) {
            throw new RuntimeException("please open the writer before invoking NearRealtimeReader");
        }
        if (runData.getIndexReader() != null) {
            throw new RuntimeException("please close the existing reader before invoking NearRealtimeReader");
        }
        long t = System.currentTimeMillis();
        IndexReader r = IndexReader.open((IndexWriter)w, (boolean)true);
        runData.setIndexReader(r);
        r.decRef();
        this.reopenCount = 0;
        while (!this.stopNow) {
            long waitForMsec = this.pauseMSec - (System.currentTimeMillis() - t);
            if (waitForMsec > 0L) {
                Thread.sleep(waitForMsec);
            }
            t = System.currentTimeMillis();
            IndexReader newReader = r.reopen();
            if (r == newReader) continue;
            int delay = (int)(System.currentTimeMillis() - t);
            if (this.reopenTimes.length == this.reopenCount) {
                this.reopenTimes = ArrayUtil.grow((int[])this.reopenTimes, (int)(1 + this.reopenCount));
            }
            this.reopenTimes[this.reopenCount++] = delay;
            runData.setIndexReader(newReader);
            newReader.decRef();
            r = newReader;
        }
        this.stopNow = false;
        return this.reopenCount;
    }

    public void setParams(String params) {
        super.setParams(params);
        this.pauseMSec = (long)(1000.0 * (double)Float.parseFloat(params));
    }

    public void close() {
        System.out.println("NRT reopen times:");
        for (int i = 0; i < this.reopenCount; ++i) {
            System.out.print(" " + this.reopenTimes[i]);
        }
        System.out.println();
    }

    public boolean supportsParams() {
        return true;
    }
}

