/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.lucene.benchmark.byTask.feeds.ContentSource;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.benchmark.byTask.utils.Config;

public class LineDocSource
extends ContentSource {
    private static final char SEP = '\t';
    private File file;
    private BufferedReader reader;
    private int readCount;

    private synchronized void openFile() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            InputStream is = this.getInputStream(this.file);
            this.reader = new BufferedReader(new InputStreamReader(is, this.encoding), 65536);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocData getNextDocData(DocData docData) throws NoMoreDataException, IOException {
        int myID;
        String line;
        LineDocSource lineDocSource = this;
        synchronized (lineDocSource) {
            line = this.reader.readLine();
            myID = this.readCount++;
            if (line == null) {
                if (!this.forever) {
                    throw new NoMoreDataException();
                }
                this.openFile();
                return this.getNextDocData(docData);
            }
        }
        int spot = line.indexOf(9);
        if (spot == -1) {
            throw new RuntimeException("line: [" + line + "] is in an invalid format !");
        }
        int spot2 = line.indexOf(9, 1 + spot);
        if (spot2 == -1) {
            throw new RuntimeException("line: [" + line + "] is in an invalid format !");
        }
        docData.clear();
        docData.setID(myID);
        docData.setBody(line.substring(1 + spot2, line.length()));
        docData.setTitle(line.substring(0, spot));
        docData.setDate(line.substring(1 + spot, spot2));
        return docData;
    }

    public void resetInputs() throws IOException {
        super.resetInputs();
        this.openFile();
    }

    public void setConfig(Config config) {
        super.setConfig(config);
        String fileName = config.get("docs.file", null);
        if (fileName == null) {
            throw new IllegalArgumentException("docs.file must be set");
        }
        this.file = new File(fileName).getAbsoluteFile();
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
    }
}

