/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.encoders;

import java.util.Locale;
import org.apache.mahout.math.Vector;
import org.apache.mahout.vectorizer.encoders.FeatureVectorEncoder;

public abstract class WordValueEncoder
extends FeatureVectorEncoder {
    private final byte[] nameBytes;

    protected WordValueEncoder(String name) {
        super(name, 2);
        this.nameBytes = this.bytesForString(name);
    }

    @Override
    public void addToVector(byte[] originalForm, double w, Vector data) {
        int probes = this.getProbes();
        String name = this.getName();
        double weight = this.getWeight(originalForm, w);
        for (int i = 0; i < probes; ++i) {
            int n = this.hashForProbe(originalForm, data.size(), name, i);
            if (this.isTraceEnabled()) {
                this.trace(originalForm, n);
            }
            data.set(n, data.get(n) + weight);
        }
    }

    @Override
    protected double getWeight(byte[] originalForm, double w) {
        return w * this.weight(originalForm);
    }

    @Override
    protected int hashForProbe(byte[] originalForm, int dataSize, String name, int probe) {
        return this.hash(this.nameBytes, originalForm, 100 + probe, dataSize);
    }

    @Override
    public String asString(String originalForm) {
        return String.format(Locale.ENGLISH, "%s:%s:%.4f", this.getName(), originalForm, this.weight(this.bytesForString(originalForm)));
    }

    protected abstract double weight(byte[] var1);
}

