/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.encoders;

import com.google.common.base.Charsets;
import java.util.Collections;
import java.util.Map;
import org.apache.mahout.vectorizer.encoders.WordValueEncoder;

public class StaticWordValueEncoder
extends WordValueEncoder {
    private Map<String, Double> dictionary;
    private double missingValueWeight = 1.0;
    private final byte[] nameBytes;

    public StaticWordValueEncoder(String name) {
        super(name);
        this.nameBytes = this.bytesForString(name);
    }

    @Override
    protected int hashForProbe(byte[] originalForm, int dataSize, String name, int probe) {
        return this.hash(this.nameBytes, originalForm, 100 + probe, dataSize);
    }

    public void setDictionary(Map<String, Double> dictionary) {
        this.dictionary = dictionary;
        this.missingValueWeight = Collections.min(dictionary.values()) / 2.0;
    }

    public void setMissingValueWeight(double missingValueWeight) {
        this.missingValueWeight = missingValueWeight;
    }

    @Override
    protected double weight(byte[] originalForm) {
        String s;
        double weight = this.missingValueWeight;
        if (this.dictionary != null && this.dictionary.containsKey(s = new String(originalForm, Charsets.UTF_8))) {
            weight = this.dictionary.get(s);
        }
        return weight;
    }
}

