/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.encoders;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.mahout.common.lucene.TokenStreamIterator;
import org.apache.mahout.vectorizer.encoders.TextValueEncoder;

public class LuceneTextValueEncoder
extends TextValueEncoder {
    private Analyzer analyzer;

    public LuceneTextValueEncoder(String name) {
        super(name);
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    protected Iterable<String> tokenize(CharSequence originalForm) {
        TokenStream ts = this.analyzer.tokenStream(this.getName(), (Reader)new CharSequenceReader(originalForm));
        ts.addAttribute(CharTermAttribute.class);
        return new LuceneTokenIterable(ts);
    }

    private static final class LuceneTokenIterable
    implements Iterable<String> {
        private boolean firstTime = true;
        private final TokenStream tokenStream;

        private LuceneTokenIterable(TokenStream ts) {
            this.tokenStream = ts;
        }

        @Override
        public Iterator<String> iterator() {
            if (this.firstTime) {
                this.firstTime = false;
            } else {
                try {
                    this.tokenStream.reset();
                }
                catch (IOException e) {
                    throw new IllegalStateException("This token stream can't be reset");
                }
            }
            return new TokenStreamIterator(this.tokenStream);
        }
    }

    private static final class CharSequenceReader
    extends Reader {
        private final CharBuffer buf;

        private CharSequenceReader(CharSequence input) {
            int n = input.length();
            this.buf = CharBuffer.allocate(n);
            for (int i = 0; i < n; ++i) {
                this.buf.put(input.charAt(i));
            }
        }

        @Override
        public int read(char[] cbuf, int off, int len) {
            this.buf.get(cbuf, off, len);
            return len;
        }

        @Override
        public void close() {
        }
    }
}

