/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.encoders;

import org.apache.mahout.vectorizer.encoders.FeatureVectorEncoder;
import org.apache.mahout.vectorizer.encoders.MurmurHash;

public abstract class CachingValueEncoder
extends FeatureVectorEncoder {
    private int[] cachedProbes;

    protected CachingValueEncoder(String name, int seed) {
        super(name);
        this.cacheProbeLocations(seed);
    }

    @Override
    public void setProbes(int probes) {
        super.setProbes(probes);
        this.cacheProbeLocations(this.getSeed());
    }

    protected abstract int getSeed();

    private void cacheProbeLocations(int seed) {
        this.cachedProbes = new int[this.getProbes()];
        for (int i = 0; i < this.getProbes(); ++i) {
            this.cachedProbes[i] = (int)MurmurHash.hash64A(this.bytesForString(this.getName()), seed + i);
        }
    }

    @Override
    protected int hashForProbe(byte[] originalForm, int dataSize, String name, int probe) {
        int h = this.cachedProbes[probe] % dataSize;
        if (h < 0) {
            h += dataSize;
        }
        return h;
    }
}

