/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.document;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.mahout.common.StringTuple;
import org.apache.mahout.vectorizer.DefaultAnalyzer;

public class SequenceFileTokenizerMapper
extends Mapper<Text, Text, Text, StringTuple> {
    private Analyzer analyzer;

    protected void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        TokenStream stream = this.analyzer.tokenStream(key.toString(), (Reader)new StringReader(value.toString()));
        CharTermAttribute termAtt = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
        StringTuple document = new StringTuple();
        while (stream.incrementToken()) {
            if (termAtt.length() <= 0) continue;
            document.add(new String(termAtt.buffer(), 0, termAtt.length()));
        }
        context.write((Object)key, (Object)document);
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        try {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            Class<?> cl = ccl.loadClass(context.getConfiguration().get("analyzer.class", DefaultAnalyzer.class.getName()));
            this.analyzer = (Analyzer)cl.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

