/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.common;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.vectorizer.common.PartialVectorMergeReducer;

public final class PartialVectorMerger {
    public static final float NO_NORMALIZING = -1.0f;
    public static final String NORMALIZATION_POWER = "normalization.power";
    public static final String DIMENSION = "vector.dimension";
    public static final String SEQUENTIAL_ACCESS = "vector.sequentialAccess";
    public static final String NAMED_VECTOR = "vector.named";
    public static final String LOG_NORMALIZE = "vector.lognormalize";

    private PartialVectorMerger() {
    }

    public static void mergePartialVectors(Iterable<Path> partialVectorPaths, Path output, Configuration baseConf, float normPower, boolean logNormalize, int dimension, boolean sequentialAccess, boolean namedVector, int numReducers) throws IOException, InterruptedException, ClassNotFoundException {
        Preconditions.checkArgument((normPower == -1.0f || normPower >= 0.0f ? 1 : 0) != 0, (String)"If specified normPower must be nonnegative", (Object[])new Object[]{Float.valueOf(normPower)});
        Preconditions.checkArgument((normPower == -1.0f || normPower > 1.0f && !Double.isInfinite(normPower) || !logNormalize ? 1 : 0) != 0, (String)"normPower must be > 1 and not infinite if log normalization is chosen", (Object[])new Object[]{Float.valueOf(normPower)});
        Configuration conf = new Configuration(baseConf);
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        conf.setBoolean(SEQUENTIAL_ACCESS, sequentialAccess);
        conf.setBoolean(NAMED_VECTOR, namedVector);
        conf.setInt(DIMENSION, dimension);
        conf.setFloat(NORMALIZATION_POWER, normPower);
        conf.setBoolean(LOG_NORMALIZE, logNormalize);
        Job job = new Job(conf);
        job.setJobName("PartialVectorMerger::MergePartialVectors");
        job.setJarByClass(PartialVectorMerger.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(VectorWritable.class);
        FileInputFormat.setInputPaths((Job)job, (String)PartialVectorMerger.getCommaSeparatedPaths(partialVectorPaths));
        FileOutputFormat.setOutputPath((Job)job, (Path)output);
        job.setMapperClass(Mapper.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setReducerClass(PartialVectorMergeReducer.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setNumReduceTasks(numReducers);
        HadoopUtil.delete(conf, output);
        job.waitForCompletion(true);
    }

    private static String getCommaSeparatedPaths(Iterable<Path> paths) {
        StringBuilder commaSeparatedPaths = new StringBuilder(100);
        String sep = "";
        for (Path path : paths) {
            commaSeparatedPaths.append(sep).append(path.toString());
            sep = ",";
        }
        return commaSeparatedPaths.toString();
    }
}

