/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.collocations.llr;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.mahout.vectorizer.collocations.llr.Gram;
import org.apache.mahout.vectorizer.collocations.llr.GramKey;

public class GramKeyPartitioner
extends Partitioner<GramKey, Gram> {
    private static final String HASH_OFFSET_PROPERTY_NAME = "grampartitioner.hash.offset";
    private int offset;

    public static void setOffsets(Configuration conf, int left, int right) {
        conf.setInt(HASH_OFFSET_PROPERTY_NAME, left);
    }

    public int getPartition(GramKey key, Gram value, int numPartitions) {
        int length = key.getLength() - 1;
        int right = (this.offset + length) % length;
        int hash = WritableComparator.hashBytes((byte[])key.getBytes(), (int)right);
        return (hash & Integer.MAX_VALUE) % numPartitions;
    }

    public void configure(Configuration conf) {
        this.offset = conf.getInt(HASH_OFFSET_PROPERTY_NAME, -1);
    }
}

