/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.collocations.llr;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.vectorizer.collocations.llr.Gram;
import org.apache.mahout.vectorizer.collocations.llr.GramKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollocReducer
extends Reducer<GramKey, Gram, Gram, Gram> {
    private static final Logger log = LoggerFactory.getLogger(CollocReducer.class);
    public static final String MIN_SUPPORT = "minSupport";
    public static final int DEFAULT_MIN_SUPPORT = 2;
    private int minSupport;

    protected void reduce(GramKey key, Iterable<Gram> values, Reducer.Context context) throws IOException, InterruptedException {
        Gram.Type keyType = key.getType();
        if (keyType == Gram.Type.UNIGRAM) {
            this.processUnigram(key, values.iterator(), context);
        } else if (keyType == Gram.Type.HEAD || keyType == Gram.Type.TAIL) {
            this.processSubgram(key, values.iterator(), context);
        } else {
            context.getCounter((Enum)Skipped.MALFORMED_TYPES).increment(1L);
        }
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        this.minSupport = conf.getInt(MIN_SUPPORT, 2);
        boolean emitUnigrams = conf.getBoolean("emit-unigrams", false);
        log.info("Min support is {}", (Object)this.minSupport);
        log.info("Emit Unitgrams is {}", (Object)emitUnigrams);
    }

    protected void processUnigram(GramKey key, Iterator<Gram> values, Reducer.Context context) throws IOException, InterruptedException {
        int freq = 0;
        Gram value = null;
        while (values.hasNext()) {
            value = values.next();
            freq += value.getFrequency();
        }
        if (freq < this.minSupport) {
            context.getCounter((Enum)Skipped.LESS_THAN_MIN_SUPPORT).increment(1L);
            return;
        }
        value.setFrequency(freq);
        context.write((Object)value, (Object)value);
    }

    protected void processSubgram(GramKey key, Iterator<Gram> values, Reducer.Context context) throws IOException, InterruptedException {
        Gram subgram = null;
        Gram currentNgram = null;
        while (values.hasNext()) {
            Gram value = values.next();
            if (value.getType() == Gram.Type.HEAD || value.getType() == Gram.Type.TAIL) {
                if (subgram == null) {
                    subgram = new Gram(value);
                    continue;
                }
                subgram.incrementFrequency(value.getFrequency());
                continue;
            }
            if (!value.equals((Object)currentNgram)) {
                if (currentNgram != null) {
                    if (currentNgram.getFrequency() < this.minSupport) {
                        context.getCounter((Enum)Skipped.LESS_THAN_MIN_SUPPORT).increment(1L);
                    } else {
                        context.write((Object)currentNgram, (Object)subgram);
                    }
                }
                currentNgram = new Gram(value);
                continue;
            }
            currentNgram.incrementFrequency(value.getFrequency());
        }
        if (currentNgram != null) {
            if (currentNgram.getFrequency() < this.minSupport) {
                context.getCounter((Enum)Skipped.LESS_THAN_MIN_SUPPORT).increment(1L);
                return;
            }
            context.write((Object)currentNgram, subgram);
        }
    }

    public static enum Skipped {
        LESS_THAN_MIN_SUPPORT,
        MALFORMED_KEY_TUPLE,
        MALFORMED_TUPLE,
        MALFORMED_TYPES,
        MALFORMED_UNIGRAM;

    }
}

