/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.lucene.analysis.Analyzer;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.StringTuple;
import org.apache.mahout.vectorizer.document.SequenceFileTokenizerMapper;

public final class DocumentProcessor {
    public static final String TOKENIZED_DOCUMENT_OUTPUT_FOLDER = "tokenized-documents";
    public static final String ANALYZER_CLASS = "analyzer.class";

    private DocumentProcessor() {
    }

    public static void tokenizeDocuments(Path input, Class<? extends Analyzer> analyzerClass, Path output, Configuration baseConf) throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = new Configuration(baseConf);
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        conf.set(ANALYZER_CLASS, analyzerClass.getName());
        Job job = new Job(conf);
        job.setJobName("DocumentProcessor::DocumentTokenizer: input-folder: " + input);
        job.setJarByClass(DocumentProcessor.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(StringTuple.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{input});
        FileOutputFormat.setOutputPath((Job)job, (Path)output);
        job.setMapperClass(SequenceFileTokenizerMapper.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        HadoopUtil.delete(conf, output);
        job.waitForCompletion(true);
    }
}

