/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDSolver;

public class VJob {
    private static final String OUTPUT_V = "v";
    private static final String PROP_UHAT_PATH = "ssvd.uhat.path";
    private static final String PROP_SIGMA_PATH = "ssvd.sigma.path";
    private static final String PROP_V_HALFSIGMA = "ssvd.v.halfsigma";
    private static final String PROP_K = "ssvd.k";
    private Job job;

    public void start(Configuration conf, Path inputPathBt, Path inputUHatPath, Path inputSigmaPath, Path outputPath, int k, int numReduceTasks, boolean vHalfSigma) throws ClassNotFoundException, InterruptedException, IOException {
        this.job = new Job(conf);
        this.job.setJobName("V-job");
        this.job.setJarByClass(VJob.class);
        this.job.setInputFormatClass(SequenceFileInputFormat.class);
        this.job.setOutputFormatClass(SequenceFileOutputFormat.class);
        FileInputFormat.setInputPaths((Job)this.job, (Path[])new Path[]{inputPathBt});
        FileOutputFormat.setOutputPath((Job)this.job, (Path)outputPath);
        this.job.getConfiguration().set("mapreduce.output.basename", OUTPUT_V);
        FileOutputFormat.setCompressOutput((Job)this.job, (boolean)true);
        FileOutputFormat.setOutputCompressorClass((Job)this.job, DefaultCodec.class);
        SequenceFileOutputFormat.setOutputCompressionType((Job)this.job, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        this.job.setMapOutputKeyClass(IntWritable.class);
        this.job.setMapOutputValueClass(VectorWritable.class);
        this.job.setOutputKeyClass(IntWritable.class);
        this.job.setOutputValueClass(VectorWritable.class);
        this.job.setMapperClass(VMapper.class);
        this.job.getConfiguration().set(PROP_UHAT_PATH, inputUHatPath.toString());
        this.job.getConfiguration().set(PROP_SIGMA_PATH, inputSigmaPath.toString());
        if (vHalfSigma) {
            this.job.getConfiguration().set(PROP_V_HALFSIGMA, "y");
        }
        this.job.getConfiguration().setInt(PROP_K, k);
        this.job.setNumReduceTasks(0);
        this.job.submit();
    }

    public void waitForCompletion() throws IOException, ClassNotFoundException, InterruptedException {
        this.job.waitForCompletion(false);
        if (!this.job.isSuccessful()) {
            throw new IOException("V job unsuccessful.");
        }
    }

    public static final class VMapper
    extends Mapper<IntWritable, VectorWritable, IntWritable, VectorWritable> {
        private Matrix uHat;
        private DenseVector vRow;
        private DenseVector sValues;
        private VectorWritable vRowWritable;
        private int kp;
        private int k;

        protected void map(IntWritable key, VectorWritable value, Mapper.Context context) throws IOException, InterruptedException {
            Vector qRow = value.get();
            for (int i = 0; i < this.k; ++i) {
                this.vRow.setQuick(i, qRow.dot(this.uHat.getColumn(i)) / this.sValues.getQuick(i));
            }
            context.write((Object)key, (Object)this.vRowWritable);
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
            Path uHatPath = new Path(context.getConfiguration().get(VJob.PROP_UHAT_PATH));
            Path sigmaPath = new Path(context.getConfiguration().get(VJob.PROP_SIGMA_PATH));
            this.uHat = new DenseMatrix(SSVDSolver.loadDistributedRowMatrix(fs, uHatPath, context.getConfiguration()));
            this.kp = this.uHat.columnSize();
            this.k = context.getConfiguration().getInt(VJob.PROP_K, this.kp);
            this.vRow = new DenseVector(this.k);
            this.vRowWritable = new VectorWritable((Vector)this.vRow);
            this.sValues = new DenseVector(SSVDSolver.loadDistributedRowMatrix(fs, sigmaPath, context.getConfiguration())[0], true);
            if (context.getConfiguration().get(VJob.PROP_V_HALFSIGMA) != null) {
                for (int i = 0; i < this.k; ++i) {
                    this.sValues.setQuick(i, Math.sqrt(this.sValues.getQuick(i)));
                }
            }
        }
    }
}

