/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;

public class UpperTriangular
extends AbstractMatrix {
    private static final double EPSILON = 1.0E-12;
    private double[] values;
    private int n;

    public UpperTriangular(int n) {
        this.values = new double[n * (n + 1) / 2];
        this.n = n;
        this.cardinality[0] = this.cardinality[1] = n;
    }

    public UpperTriangular(Vector data) {
        this.cardinality[0] = this.cardinality[1] = (this.n = (int)Math.round((-1.0 + Math.sqrt(1 + 8 * data.size())) / 2.0));
        this.values = new double[this.n * (this.n + 1) / 2];
        int n = data.size();
        for (int i = 0; i < n; ++i) {
            this.values[i] = data.getQuick(i);
        }
    }

    public UpperTriangular(double[] data, boolean shallow) {
        if (data == null) {
            throw new IllegalArgumentException("data");
        }
        this.values = shallow ? data : (double[])data.clone();
        this.cardinality[0] = this.cardinality[1] = (this.n = (int)Math.round((-1.0 + Math.sqrt(1 + 8 * data.length)) / 2.0));
    }

    public UpperTriangular(UpperTriangular mx) {
        this(mx.values, false);
    }

    public Matrix assignColumn(int column, Vector other) {
        throw new UnsupportedOperationException();
    }

    public Matrix assignRow(int row, Vector other) {
        int i;
        for (i = 0; i < row; ++i) {
            if (!(other.getQuick(i) > 1.0E-12)) continue;
            throw new IllegalArgumentException("non-triangular source");
        }
        for (i = row; i < this.n; ++i) {
            this.setQuick(row, i, other.get(i));
        }
        return this;
    }

    public Matrix assignRow(int row, double[] other) {
        System.arraycopy(other, row, this.values, this.getL(row, row), this.n - row);
        return this;
    }

    public Vector getColumn(int column) {
        throw new UnsupportedOperationException();
    }

    public Vector getRow(int row) {
        throw new UnsupportedOperationException();
    }

    public double getQuick(int row, int column) {
        if (row > column) {
            return 0.0;
        }
        return this.values[this.getL(row, column)];
    }

    private int getL(int row, int col) {
        return (((this.n << 1) - row + 1) * row >> 1) + col - row;
    }

    public Matrix like() {
        throw new UnsupportedOperationException();
    }

    public Matrix like(int rows, int columns) {
        throw new UnsupportedOperationException();
    }

    public void setQuick(int row, int column, double value) {
        this.values[this.getL((int)row, (int)column)] = value;
    }

    public int[] getNumNondefaultElements() {
        throw new UnsupportedOperationException();
    }

    public Matrix viewPart(int[] offset, int[] size) {
        throw new UnsupportedOperationException();
    }

    double[] getData() {
        return this.values;
    }
}

