/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDSolver;

public class UJob {
    private static final String OUTPUT_U = "u";
    private static final String PROP_UHAT_PATH = "ssvd.uhat.path";
    private static final String PROP_SIGMA_PATH = "ssvd.sigma.path";
    private static final String PROP_U_HALFSIGMA = "ssvd.u.halfsigma";
    private static final String PROP_K = "ssvd.k";
    private Job job;

    public void start(Configuration conf, Path inputPathQ, Path inputUHatPath, Path sigmaPath, Path outputPath, int k, int numReduceTasks, Class<? extends Writable> labelClass, boolean uHalfSigma) throws ClassNotFoundException, InterruptedException, IOException {
        this.job = new Job(conf);
        this.job.setJobName("U-job");
        this.job.setJarByClass(UJob.class);
        this.job.setInputFormatClass(SequenceFileInputFormat.class);
        this.job.setOutputFormatClass(SequenceFileOutputFormat.class);
        FileInputFormat.setInputPaths((Job)this.job, (Path[])new Path[]{inputPathQ});
        FileOutputFormat.setOutputPath((Job)this.job, (Path)outputPath);
        this.job.getConfiguration().set("mapreduce.output.basename", OUTPUT_U);
        FileOutputFormat.setCompressOutput((Job)this.job, (boolean)true);
        FileOutputFormat.setOutputCompressorClass((Job)this.job, DefaultCodec.class);
        SequenceFileOutputFormat.setOutputCompressionType((Job)this.job, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        this.job.setMapperClass(UMapper.class);
        this.job.setMapOutputKeyClass(IntWritable.class);
        this.job.setMapOutputValueClass(VectorWritable.class);
        this.job.setOutputKeyClass(labelClass);
        this.job.setOutputValueClass(VectorWritable.class);
        this.job.getConfiguration().set(PROP_UHAT_PATH, inputUHatPath.toString());
        this.job.getConfiguration().set(PROP_SIGMA_PATH, sigmaPath.toString());
        if (uHalfSigma) {
            this.job.getConfiguration().set(PROP_U_HALFSIGMA, "y");
        }
        this.job.getConfiguration().setInt(PROP_K, k);
        this.job.setNumReduceTasks(0);
        this.job.submit();
    }

    public void waitForCompletion() throws IOException, ClassNotFoundException, InterruptedException {
        this.job.waitForCompletion(false);
        if (!this.job.isSuccessful()) {
            throw new IOException("U job unsuccessful.");
        }
    }

    public static final class UMapper
    extends Mapper<Writable, VectorWritable, Writable, VectorWritable> {
        private Matrix uHat;
        private DenseVector uRow;
        private VectorWritable uRowWritable;
        private int kp;
        private int k;
        private Vector sValues;

        protected void map(Writable key, VectorWritable value, Mapper.Context context) throws IOException, InterruptedException {
            Vector qRow = value.get();
            if (this.sValues != null) {
                for (int i = 0; i < this.k; ++i) {
                    this.uRow.setQuick(i, qRow.dot(this.uHat.getColumn(i)) * this.sValues.getQuick(i));
                }
            } else {
                for (int i = 0; i < this.k; ++i) {
                    this.uRow.setQuick(i, qRow.dot(this.uHat.getColumn(i)));
                }
            }
            context.write((Object)key, (Object)this.uRowWritable);
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
            Path uHatPath = new Path(context.getConfiguration().get(UJob.PROP_UHAT_PATH));
            Path sigmaPath = new Path(context.getConfiguration().get(UJob.PROP_SIGMA_PATH));
            this.uHat = new DenseMatrix(SSVDSolver.loadDistributedRowMatrix(fs, uHatPath, context.getConfiguration()));
            this.kp = this.uHat.columnSize();
            this.k = context.getConfiguration().getInt(UJob.PROP_K, this.kp);
            this.uRow = new DenseVector(this.k);
            this.uRowWritable = new VectorWritable((Vector)this.uRow);
            if (context.getConfiguration().get(UJob.PROP_U_HALFSIGMA) != null) {
                this.sValues = new DenseVector(SSVDSolver.loadDistributedRowMatrix(fs, sigmaPath, context.getConfiguration())[0], true);
                for (int i = 0; i < this.k; ++i) {
                    this.sValues.setQuick(i, Math.sqrt(this.sValues.getQuick(i)));
                }
            }
        }
    }
}

