/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.common.IOUtils;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterable;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.BBtJob;
import org.apache.mahout.math.hadoop.stochasticsvd.BtJob;
import org.apache.mahout.math.hadoop.stochasticsvd.QJob;
import org.apache.mahout.math.hadoop.stochasticsvd.UJob;
import org.apache.mahout.math.hadoop.stochasticsvd.UpperTriangular;
import org.apache.mahout.math.hadoop.stochasticsvd.VJob;
import org.apache.mahout.math.ssvd.EigenSolverWrapper;

public class SSVDSolver {
    private double[] svalues;
    private boolean computeU = true;
    private boolean computeV = true;
    private String uPath;
    private String vPath;
    private final Configuration conf;
    private final Path[] inputPath;
    private final Path outputPath;
    private final int ablockRows;
    private final int k;
    private final int p;
    private final int reduceTasks;
    private int minSplitSize = -1;
    private boolean cUHalfSigma;
    private boolean cVHalfSigma;
    private boolean overwrite;
    private static final Pattern OUTPUT_FILE_PATTERN = Pattern.compile("(\\w+)-(m|r)-(\\d+)(\\.\\w+)?");
    static final Comparator<FileStatus> PARTITION_COMPARATOR = new Comparator<FileStatus>(){
        private final Matcher matcher = SSVDSolver.access$000().matcher("");

        @Override
        public int compare(FileStatus o1, FileStatus o2) {
            this.matcher.reset(o1.getPath().getName());
            if (!this.matcher.matches()) {
                throw new IllegalArgumentException("Unexpected file name, unable to deduce partition #:" + o1.getPath());
            }
            int p1 = Integer.parseInt(this.matcher.group(3));
            this.matcher.reset(o2.getPath().getName());
            if (!this.matcher.matches()) {
                throw new IllegalArgumentException("Unexpected file name, unable to deduce partition #:" + o2.getPath());
            }
            int p2 = Integer.parseInt(this.matcher.group(3));
            return p1 - p2;
        }
    };

    public SSVDSolver(Configuration conf, Path[] inputPath, Path outputPath, int ablockRows, int k, int p, int reduceTasks) {
        this.conf = conf;
        this.inputPath = inputPath;
        this.outputPath = outputPath;
        this.ablockRows = ablockRows;
        this.k = k;
        this.p = p;
        this.reduceTasks = reduceTasks;
    }

    public void setcUHalfSigma(boolean cUHat) {
        this.cUHalfSigma = cUHat;
    }

    public void setcVHalfSigma(boolean cVHat) {
        this.cVHalfSigma = cVHat;
    }

    public void setComputeU(boolean val) {
        this.computeU = val;
    }

    public void setComputeV(boolean val) {
        this.computeV = val;
    }

    public void setMinSplitSize(int size) {
        this.minSplitSize = size;
    }

    public double[] getSingularValues() {
        return this.svalues;
    }

    public String getUPath() {
        return this.uPath;
    }

    public String getVPath() {
        return this.vPath;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void run() throws IOException {
        LinkedList<SequenceFile.Writer> closeables = new LinkedList<SequenceFile.Writer>();
        try {
            int i;
            Class<? extends Writable> labelType = SSVDSolver.sniffInputLabelType(this.inputPath, this.conf);
            FileSystem fs = FileSystem.get((Configuration)this.conf);
            Path qPath = new Path(this.outputPath, "Q-job");
            Path btPath = new Path(this.outputPath, "Bt-job");
            Path bbtPath = new Path(this.outputPath, "BBt-job");
            Path uHatPath = new Path(this.outputPath, "UHat");
            Path svPath = new Path(this.outputPath, "Sigma");
            Path uPath = new Path(this.outputPath, "U");
            Path vPath = new Path(this.outputPath, "V");
            if (this.overwrite) {
                fs.delete(this.outputPath, true);
            }
            Random rnd = RandomUtils.getRandom();
            long seed = rnd.nextLong();
            QJob.run(this.conf, this.inputPath, qPath, this.ablockRows, this.minSplitSize, this.k, this.p, seed, this.reduceTasks);
            BtJob.run(this.conf, this.inputPath, qPath, btPath, this.minSplitSize, this.k, this.p, this.reduceTasks, labelType);
            BBtJob.run(this.conf, new Path(btPath, "part-*"), bbtPath, 1);
            UpperTriangular bbt = SSVDSolver.loadUpperTriangularMatrix(fs, new Path(bbtPath, "part-*"), this.conf);
            assert (bbt.columnSize() == this.k + this.p);
            double[][] bbtSquare = new double[this.k + this.p][];
            for (i = 0; i < this.k + this.p; ++i) {
                bbtSquare[i] = new double[this.k + this.p];
            }
            for (i = 0; i < this.k + this.p; ++i) {
                for (int j = i; j < this.k + this.p; ++j) {
                    double d = bbt.getQuick(i, j);
                    bbtSquare[j][i] = d;
                    bbtSquare[i][j] = d;
                }
            }
            this.svalues = new double[this.k + this.p];
            EigenSolverWrapper eigenWrapper = new EigenSolverWrapper((double[][])bbtSquare);
            double[] eigenva2 = eigenWrapper.getEigenValues();
            for (int i2 = 0; i2 < this.k + this.p; ++i2) {
                this.svalues[i2] = Math.sqrt(eigenva2[i2]);
            }
            double[][] uHat = eigenWrapper.getUHat();
            fs.mkdirs(uHatPath);
            uHatPath = new Path(uHatPath, "uhat.seq");
            SequenceFile.Writer uHatWriter = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.conf, (Path)uHatPath, IntWritable.class, VectorWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
            closeables.addFirst(uHatWriter);
            int m = uHat.length;
            IntWritable iw = new IntWritable();
            VectorWritable vw = new VectorWritable();
            for (int i3 = 0; i3 < m; ++i3) {
                vw.set((Vector)new DenseVector(uHat[i3], true));
                iw.set(i3);
                uHatWriter.append((Writable)iw, (Writable)vw);
            }
            closeables.remove(uHatWriter);
            uHatWriter.close();
            svPath = new Path(svPath, "svalues.seq");
            SequenceFile.Writer svWriter = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.conf, (Path)svPath, IntWritable.class, VectorWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
            closeables.addFirst(svWriter);
            vw.set((Vector)new DenseVector(this.svalues, true));
            svWriter.append((Writable)iw, (Writable)vw);
            closeables.remove(svWriter);
            svWriter.close();
            UJob ujob = null;
            if (this.computeU) {
                ujob = new UJob();
                ujob.start(this.conf, new Path(btPath, "Q-*"), uHatPath, svPath, uPath, this.k, this.reduceTasks, labelType, this.cUHalfSigma);
            }
            VJob vjob = null;
            if (this.computeV) {
                vjob = new VJob();
                vjob.start(this.conf, new Path(btPath, "part-*"), uHatPath, svPath, vPath, this.k, this.reduceTasks, this.cVHalfSigma);
            }
            if (ujob != null) {
                ujob.waitForCompletion();
                this.uPath = uPath.toString();
            }
            if (vjob != null) {
                vjob.waitForCompletion();
                this.vPath = vPath.toString();
            }
        }
        catch (InterruptedException exc) {
            throw new IOException("Interrupted", exc);
        }
        catch (ClassNotFoundException exc) {
            throw new IOException(exc);
        }
        finally {
            IOUtils.close(closeables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<? extends Writable> sniffInputLabelType(Path[] inputPath, Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        for (Path p : inputPath) {
            FileStatus[] fstats = fs.globStatus(p);
            if (fstats == null || fstats.length == 0) continue;
            SequenceFile.Reader r = new SequenceFile.Reader(fs, fstats[0].getPath(), conf);
            try {
                Class<Writable> clazz = r.getKeyClass().asSubclass(Writable.class);
                return clazz;
            }
            finally {
                r.close();
            }
        }
        throw new IOException("Unable to open input files to determine input label type.");
    }

    public static double[][] loadDistributedRowMatrix(FileSystem fs, Path glob, Configuration conf) throws IOException {
        FileStatus[] files = fs.globStatus(glob);
        if (files == null) {
            return null;
        }
        ArrayList<double[]> denseData = new ArrayList<double[]>();
        Arrays.sort(files, PARTITION_COMPARATOR);
        for (FileStatus fstat : files) {
            for (VectorWritable value : new SequenceFileValueIterable(fstat.getPath(), true, conf)) {
                Vector v = value.get();
                int size = v.size();
                double[] row = new double[size];
                for (int i = 0; i < size; ++i) {
                    row[i] = v.get(i);
                }
                denseData.add(row);
            }
        }
        return (double[][])denseData.toArray((T[])new double[denseData.size()][]);
    }

    public static UpperTriangular loadUpperTriangularMatrix(FileSystem fs, Path glob, Configuration conf) throws IOException {
        FileStatus[] files = fs.globStatus(glob);
        if (files == null) {
            return null;
        }
        Arrays.sort(files, PARTITION_COMPARATOR);
        UpperTriangular result = null;
        for (FileStatus fstat : files) {
            for (VectorWritable value : new SequenceFileValueIterable(fstat.getPath(), true, conf)) {
                Vector v = value.get();
                if (result == null) {
                    result = new UpperTriangular(v);
                    continue;
                }
                throw new IOException("Unexpected overrun in upper triangular matrix files");
            }
        }
        if (result == null) {
            throw new IOException("Unexpected underrun in upper triangular matrix files");
        }
        return result;
    }

    static /* synthetic */ Pattern access$000() {
        return OUTPUT_FILE_PATTERN;
    }
}

